<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\User;
use App\Models\Order;
use App\Models\Log;
use App\Models\DuplicateOrder;
use Carbon\Carbon;
use App\Models\Message;
class ManagerController extends Controller
{
    public function dashboard(){
        $chartData = $this->chartData();
        return view('manager.dashboard',compact('chartData'));
    }

    public function importData(){

        $shheet = Sheets::spreadsheet('1d7d9vis9i6UT6pL840QiNvUZc3RGGeI4fqyz19v71RE')->sheet('Demo')->get();

        $header = $shheet->pull(0);
        $values = Sheets::collection($header, $shheet);
        $jsonData = array_values($values->toArray());
        foreach($jsonData as $data){

            $checkOrder = Order::where('date',$data['date'])->where('phone',$data['phone'])->where('product_name',$data['productName'])->count();
            if($checkOrder == 0)
            {

                $prevOrder = Order::where('phone',$data['phone'])->where('product_name',$data['productName'])->count();
                if($prevOrder == 0){
                    $employee = $this->getAvailableEmployees($data['date']);
                    $order = new Order();
                    $order->employee_id = $employee;
                    $order->date = $data['date'];
                    $order->full_name = $data['fullname'];
                    $order->phone = $data['phone'];
                    $order->address = $data['address2'];
                    $order->city = $data['city'];
                    $order->product_name = $data['productName'];
                    $order->price = 0;
                    $order->source = 'Excel Sheet';
                    $order->status = $data['orderStatus'];
                    $order->product_variant = $data['productVariant'];
                    $order->save();
                }else{
                    $preOrder = Order::where('phone',$data['phone'])->where('product_name',$data['productName'])->orderBy('id','desc')->first();
                    $duplicateOrder = new DuplicateOrder();
                    $duplicateOrder->order_id = $preOrder->id;
                    $duplicateOrder->date = $data['date'];
                    $duplicateOrder->full_name = $data['fullname'];
                    $duplicateOrder->phone = $data['phone'];
                    $duplicateOrder->address = $data['address2'];
                    $duplicateOrder->city = $data['city'];
                    $duplicateOrder->product_name = $data['productName'];
                    $duplicateOrder->price = 0;
                    $duplicateOrder->source = 'Excel Sheet';
                    $duplicateOrder->status = $data['orderStatus'];
                    $duplicateOrder->product_variant = $data['productVariant'];
                    $duplicateOrder->save();
                }

            }


        }


        return redirect()->route('manager.order-report')->with('success','Success! Orders Imported Successfully.');

    }
    public function logout()
    {
        $user = User::find(session('current_manager')->id);
        session()->forget("current_manager");
        $log = new Log();
        $log->details = "Manager ".$user->name." Logged out.";
        $log->user_id = $user->id;
        $log->save();
        return redirect()->route('login')->with('success','Success! Logged Out Successfully.');
    }
    public function manageEmployees(Request $request){
        $employees = User::where('role','employee')->get();
        return view('manager.manage-employees',compact('employees'));
    }
    public function editEmployee(Request $request){
        $current_employee = User::find($request->id);
        if(isset($current_employee)){
            $employees = User::where('role','employee')->get();
            return view("manager.edit-employee",compact("current_employee","employees"));
        }else{
            return redirect()->route("manager.manage-employees")->with("error","Oops! Something Went Wrong. Try Again!");
        }
    }
    public function updateEmployee(Request $request){
        $request->validate([
            'employee' => 'required',
            'name' =>'required',
            'phone' =>'required',
            'email' =>'required | unique:users,email,'.$request->employee,
            'orders_limit' =>'required',
        ]);
        $current_employee = User::find($request->employee);
        if(isset($current_employee)){
            $current_employee->name = $request->name;
            $current_employee->phone = $request->phone;
            $current_employee->email = $request->email;
            $current_employee->orders_limit = $request->orders_limit;
            if(isset($request->password)){
                $current_employee->password = $request->password;
            }
            $current_employee->update();
            return redirect()->route("manager.manage-employees")->with("success",'Success! Employee Updated Successfully.');
        }else{
            return redirect()->route("manager.manage-employees")->with("error","Oops! Something Went Wrong. Try Again!");
        }
    }
    public function orderReport(Request $request){
        $employees = User::where('role','employee')->get();
        $orders = Order::all();
        return view('manager.order-report',compact('employees','orders'));
    }
    public function searchOrderReport(Request $request){
        $employee1 = ""; $status1 = ""; $date1 = "";
        $orderReport = Order::query();
        if(isset($request->date) && $request->date != "Select a Date"){
            $date = explode('-', $request->date);
            $from_date = Carbon::createFromFormat('m/d/Y', trim($date[0]))->format('d/m/Y');
            $to_date = Carbon::createFromFormat('m/d/Y', trim($date[1]) )->format('d/m/Y');
            $orderReport->whereBetween('date', [$from_date, $to_date]);
            $date1 = $request->date;
        }elseif(isset($request->date) && $request->date == "Select a Date"){
            $date1 = "Select a Date";
        }
        if(isset($request->employee)){
            $orderReport->where('employee_id',$request->employee);
            $employee1 = $request->employee; 
        }
        if(isset($request->status)){
            $orderReport->where('status',$request->status);
            $status1 = $request->status;
        }
        $orders = $orderReport->get();
        $employees = User::where('role','employee')->get();
        return view('manager.search-order-report',compact('orders','employees','employee1','status1','date1'));
    }
    public function employeeOrders(Request $request){
        $request->employee = $request->id;
        echo $this->searchOrderReport($request);
    }
    public function getOrderChartbyDate(Request $request){
        $request->validate([
            'employee' => 'required',
            'start_date' => 'required',
            'end_date' => 'required',
        ]);
        $from_date = Carbon::createFromFormat('d/m/Y', trim($request->start_date))->format('d/m/Y');
        $to_date = Carbon::createFromFormat('d/m/Y', trim($request->end_date) )->format('d/m/Y');
        $pendingOrders = Order::where('employee_id',$request->employee)->whereBetween('date', [$from_date, $to_date])->where('status','Pending')->count();
        $confirmedOrders = Order::where('employee_id',$request->employee)->whereBetween('date', [$from_date, $to_date])->where('status','Confirmed')->count();
        $pickedOrders = Order::where('employee_id',$request->employee)->whereBetween('date', [$from_date, $to_date])->where('status','Picked Up')->count();
        $returnedOrders = Order::where('employee_id',$request->employee)->whereBetween('date', [$from_date, $to_date])->where('status','Returned')->count();
        $delieveredOrders = Order::where('employee_id',$request->employee)->whereBetween('date', [$from_date, $to_date])->where('status','Delivered')->count();
        $orders = [$pendingOrders,$confirmedOrders,$pickedOrders,$returnedOrders,$delieveredOrders];
        return $orders;
    }
    public function employeeReport(Request $request){
        $employee = User::find($request->id);
        return view('manager.employee-report',compact('employee'));
    }

    public function messages (){
        return view ('manager.messages');
    }
    public function addMessage(Request $request){
        $user = User::find($request->id);
        $current_user = session('current_manager')->id;
        if(!isset($user) || $request->id == $current_user ){
            return redirect('/')->with('error','Oops! Something Went Wrong.');
        }else{
            return view('manager.add-Message',compact('user'));
        }
    }

    public function editProfile(){
        $user = User::find(session('current_manager')->id);
        return view('manager.edit-profile',compact('user'));
    }
    public function updateProfile(Request $request){
        $request->validate([
            'name' => 'required',
        ]);
        $user = User::find(session('current_manager')->id);
        if(isset($request->picture)){
            $file = $request->file('picture');
            $file_name = "UserProfile-".md5(microtime()).'.'.$file->getClientOriginalExtension();
            $destinationpath = 'layout/assets/avatars';
            $file->move($destinationpath,$file_name);
            $user->image = $file_name;
        }
        if(isset($request->password)){
            $user->password = $request->password;
        }
        $user->save();
        return redirect()->route('manager.edit-profile')->with('success','Success! Profile Updated Successfully.');
    }
    private function fetchOrders($employeeId, $date,$status){
        $orders = DB::table('orders')
            ->select('*')
            ->where('status',$status)
            ->where('employee_id', $employeeId)
            ->where('date', $date)
            ->count();

        return $orders;
    }
    private function chartData(){
        $today = Carbon::today()->format('Y-m-d');
        $yesterday = Carbon::yesterday()->format('Y-m-d');
        $dayBeforeYesterday = Carbon::yesterday()->subDays(1)->format('Y-m-d');
        $employees = User::where('role','employee')->get();
        $employeeData = [];

        foreach ($employees as $employee) {
            $employeeOrders = [];
            $pendingOrdersToday = $this->fetchOrders($employee->id, $today,"Pending");
            $confirmedOrdersToday = $this->fetchOrders($employee->id, $today,"Confirmed");
            $pickedOrdersToday = $this->fetchOrders($employee->id, $today,"Picked Up");
            $returnedOrdersToday = $this->fetchOrders($employee->id, $today,"Returned");
            $deliveredOrdersToday = $this->fetchOrders($employee->id, $today,"Delivered");

            $pendingOrdersYesterday = $this->fetchOrders($employee->id, $yesterday,"Pending");
            $confirmedOrdersYesterday = $this->fetchOrders($employee->id, $yesterday,"Confirmed");
            $pickedOrdersYesterday = $this->fetchOrders($employee->id, $yesterday,"Picked Up");
            $returnedOrdersYesterday= $this->fetchOrders($employee->id, $yesterday,"Returned");
            $deliveredOrdersYesterday = $this->fetchOrders($employee->id, $yesterday,"Delivered");

            $pendingOrdersDayBeforeYesterday = $this->fetchOrders($employee->id, $dayBeforeYesterday,"Pending");
            $confirmedOrdersDayBeforeYesterday = $this->fetchOrders($employee->id, $dayBeforeYesterday,"Confirmed");
            $pickedOrdersDayBeforeYesterday = $this->fetchOrders($employee->id, $dayBeforeYesterday,"Picked Up");
            $returnedOrdersDayBeforeYesterday = $this->fetchOrders($employee->id, $dayBeforeYesterday,"Returned");
            $deliveredOrdersDayBeforeYesterday = $this->fetchOrders($employee->id, $dayBeforeYesterday,"Delivered");


            $employeeOrders[$today] = [$pendingOrdersToday,$confirmedOrdersToday, $pickedOrdersToday, $returnedOrdersToday, $deliveredOrdersToday];
            $employeeOrders[$yesterday] = [$pendingOrdersYesterday,$confirmedOrdersYesterday, $pickedOrdersYesterday, $returnedOrdersYesterday, $deliveredOrdersYesterday];
            $employeeOrders[$dayBeforeYesterday] = [$pendingOrdersDayBeforeYesterday,$confirmedOrdersDayBeforeYesterday, $pickedOrdersDayBeforeYesterday, $returnedOrdersDayBeforeYesterday, $deliveredOrdersDayBeforeYesterday];

            $employeeData[$employee->name] = $employeeOrders;
        }
        return json_encode($employeeData);
    }
}
