<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Log;
use App\Models\Message;
use Session;

class UserController extends Controller
{
    public function login(Request $request){
        return view('admin.login');
    }
    public function checkLogin(Request $request){
        $request->validate([
            'email' =>'required',
            'password' => 'required',
        ]);
        $user = User::where("email",$request->email)->where("password",$request->password)->get();
        if($user->count() > 0)
        {
            $user = User::where("email",$request->email)->where("password",$request->password)->first();


            if ($user->role == 'employee' && $user->status == 'Inactif') {
                return redirect()->route('login')->with('error', 'Ce Compte est inactive veuillez contactez l\'administrateur');
            }

            if($user->role == 'admin'){
                session(["current_admin" => $user]);
                // $log = new Log();
                // $log->details = "Admin ".$user->name." Logged in into his Account";
                // $log->user_id = $user->id;
                // $log->save();
                
                return redirect()->route('admin.dashboard')->with("success","Login successfully!");
            // } else if($user->role == 'employee'){
            //     Session::put('last_activity', time());
            //     session(["current_employee" => $user]);
            //     // $log = new Log();
            //     // $log->details = "Employee ".$user->name." Logged in into his Account";
            //     // $log->user_id = $user->id;
            //     // $log->save();
            //     return redirect()->route('employee.dashboard')->with("success","Connection avec succès!");
            }
        }
        else{
            return redirect()->route('login')->with("error","Details entrées sont incorrects!");
        }
    }


    public function elogin(Request $request){

        $employees = User::where('role', 'employee')->get();

        return view('employee.login', compact('employees'));
    }



    public function echeckLogin(Request $request){
        $request->validate([
            'employee_id' =>'required',
            'password' => 'required',
        ]);
        $user = User::where("id",$request->employee_id)->where("password",$request->password)->get();
        if($user->count() > 0)
        {
            $user = User::where("id",$request->employee_id)->where("password",$request->password)->first();

            if($user->role == 'employee' && $user->is_couvreur == 0){
                // \Log::info('infos:', $request->all());
                Session::put('last_activity', time());
                session(["current_employee" => $user]);

                return redirect()->route('employee.dashboard')->with("success","Connection avec succès!");
            }
            else if($user->role == 'employee' && $user->is_couvreur == 1){
                Session::put('last_activity', time());
                session(["current_couvreur" => $user]);
                
                return redirect()->route('couvreur.dashboard')->with("success","Connection avec succès!");
            }
        }
        else{
            return redirect()->route('employee.login')->with("error","Details entrées sont incorrects!");
        }
    }





    
    public function register(request $request){
        return view('admin.register');
    }


    public function getMessages(Request $request){
        if(session()->has('current_manager')){
            $current_user = session('current_manager')->id;
        }else if(session()->has('current_employee')){
            $current_user = session('current_employee')->id;
        }else if(session()->has('current_admin')){
            $current_user = session('current_admin')->id;
        }else{
            return redirect('/')->with('error','Oops! Something Went Wrong.');
        }
        $user = User::find($request->id);
        $me  = User::find($current_user);
        $messages = Message::where([
            ['sent_to',$me->id],
            ['sent_from',$user->id]
        ])->orWhere([
            ['sent_to',$user->id],
            ['sent_from',$me->id]
        ])->get();
        $unseen = Message::where('sent_to',$me->id)->where('sent_from',$user->id)->update(['status' =>'seen']);
        return view('messages',compact('user','me','messages'))->render();
    }
    public function getChats(Request $request){
        if(session()->has('current_manager')){
            $current_user = session('current_manager')->id;
        }else if(session()->has('current_employee')){
            $current_user = session('current_employee')->id;
        }else if(session()->has('current_admin')){
            $current_user = session('current_admin')->id;
        }else{
            return redirect('/')->with('error','Oops! Something Went Wrong.');
        }
        if(isset($request->id)){
            $user = User::find($request->id);
            $id = $user->id;
        }else{
            $id = 0;
        }
        
        $me  = User::find($current_user);
        $chats_list =array();
        $chat_list = Message::where('sent_from',$me->id)->orWhere('sent_to',$me->id)->latest()->get();
        foreach($chat_list as $list){
            if($list->sent_from == $me->id){
                $chat_user = $list->sent_to;
            }else if($list->sent_to == $me->id){
                $chat_user = $list->sent_from;
            }
            if(!in_array($chat_user,$chats_list)){
                array_push($chats_list,$chat_user);
            }
        }
        return view('chat-list',compact('id','me','chats_list'))->render();
    }
    public function updateStatus (Request $request){
        $user = User::find($request->user);
        $user->online = strtotime("now");
        $user->update();
    }
    public function sendMessage (Request $request){
        $user = User::find($request->id);

        if(session()->has('current_manager')){
            $current_user = session('current_manager')->id;
        }else if(session()->has('current_employee')){
            $current_user = session('current_employee')->id;
        }else if(session()->has('current_admin')){
            $current_user = session('current_admin')->id;
        }else{
            return redirect('/')->with('error','Oops! Something Went Wrong.');
        }

        if(!isset($user) || $request->id == $current_user ){
            return redirect('/')->with('error','Oops! Something Went Wrong.');
        }else{
            $message = new Message();
            $message->sent_from = $current_user;
            $message->sent_to = $user->id;
            $message->message = $request->message;
            if(isset($request->attachment))
             {
                $file = $request->file('attachment');
                $file_name = "Attachment-".md5(microtime()).'.'.$file->getClientOriginalExtension();
                $destinationpath = 'layout/assets/images/attachments';
                $file->move($destinationpath,$file_name);
                $message->attachment = $file_name;
            }
            $message->save();

            return redirect()->back();
        }
    }


    public function index(Request $request){
        if(session()->has('current_employee')){
            return redirect()->route('employee.dashboard');
        }else if(session()->has('current_admin')){
            return redirect()->route('admin.dashboard');
        }else if(session()->has('current_couvreur')){
            return redirect()->route('couvreur.dashboard');
        }else{
            return redirect()->route('employee.login');
        }
    }


}
