<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ElementRequest extends Model
{
    use HasFactory;
    
    protected $fillable = [
        'employee_id',
        'element_id', 
        'quantity_requested',
        'status',
        'reason',
        'admin_notes'
    ];
    
    public function employee()
    {
        return $this->belongsTo(User::class, 'employee_id');
    }
    
    public function element()
    {
        return $this->belongsTo(Element::class);
    }
}