<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Chantier;
use App\Models\Tache;
use App\Models\User;

class Event extends Model
{
    use HasFactory;

    protected $fillable = [
        'employee_id',
        'chantier_id',
        'taches_id',
        'note'
    ];

    public function chantier()
    {
        return $this->belongsTo(Chantier::class, 'chantier_id');
    }

    public function tache()
    {
        return $this->belongsTo(Tache::class, 'taches_id');
    }

    public function employee()
    {
        return $this->belongsTo(User::class, 'employee_id');
    }
}
