<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MaterielRequest extends Model
{
    use HasFactory;
    
    protected $fillable = [
        'employee_id',
        'materiel_id', 
        'status',
        'reason',
        'admin_notes',
        'date_needed'
    ];
    
    public function employee()
    {
        return $this->belongsTo(User::class, 'employee_id');
    }
    
    public function materiel()
    {
        return $this->belongsTo(Materiel::class);
    }
}