<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Notification extends Model
{
    protected $table = "notifications";

    protected $fillable = ['title', 'content', 'image', 'type', 'end_date', 'for_all_employees'];

    public function employees()
    {
        return $this->belongsToMany(User::class, 'employee_notifications', 'notification_id', 'employee_id');
    }
}
