<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class User extends Model
{
    use HasFactory;
    protected $table = "users";

    protected $fillable = [
        'name',
        'email',
        'password',
        'role',
        'display_order',
        'is_couvreur'
    ];

    public function notifications()
    {
        return $this->belongsToMany(Notification::class, 'employee_notifications', 'employee_id', 'notification_id');
    }

    public function taches()
    {
        return $this->hasManyThrough(
            Tache::class,
            'employees',
            'id', // Local key on users table
            'employees', // Foreign key on taches table (JSON column)
            null, // Local key
            null // Foreign key
        )->where('role', 'employee');
    }
}
