<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateNotificationsTable extends Migration
{
    public function up()
    {
        Schema::create('notifications', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('employee_id'); // Reference to the employee
            $table->enum('type', ['text', 'image']); // Type of notification
            $table->string('alert_type')->nullable(); // Type of alert (info, danger, warning)
            $table->string('message')->nullable(); // Notification message if it's text
            $table->string('image_path')->nullable(); // Path to the image if it's an image
            $table->date('end_date')->nullable(); // End date for the alert
            $table->timestamps();

            // Foreign key constraint
            $table->foreign('employee_id')->references('id')->on('users')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('notifications');
    }
}
