@extends('admin.layout')
@section('title') Absences @endsection
@section('content')
<div class="row">
    <div class="col-lg-12 grid-margin stretch-card">
        <div class="card">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h4 class="card-title">Liste des Absences</h4>
                    <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#addAbsenceModal">
                        <i class="fa fa-plus"></i> Ajouter une Absence
                    </button>
                </div>

                <!-- Date Range Filter -->
                <form method="GET" class="mb-4">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="start_date">Date de début</label>
                                <input type="date" class="form-control" name="start_date" value="{{ $start_date }}">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="end_date">Date de fin</label>
                                <input type="date" class="form-control" name="end_date" value="{{ $end_date }}">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>&nbsp;</label>
                                <button type="submit" class="btn btn-primary d-block">Filtrer</button>
                                <a href="{{ route('admin.absences') }}" class="btn btn-secondary d-block mt-2">Ce mois</a>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <small class="text-muted">Période affichée: {{ Carbon\Carbon::parse($start_date)->format('d/m/Y') }} au {{ Carbon\Carbon::parse($end_date)->format('d/m/Y') }}</small>
                        </div>
                    </div>
                </form>

                <div class="table-responsive">
                    <table class="table table-striped table-borderless datatables" id="table1">
                        <thead>
                            <tr>
                                <th>Salarié</th>
                                <th>Type</th>
                                <th>Date de début</th>
                                <th>Date de fin</th>
                                <th>Jours absents</th>
                                <th>Statut</th>
                                <th>Raison</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($absences as $absence)
                            <tr>
                                <td>{{ $absence->employee->prenom ?? '' }} {{ $absence->employee->name ?? '' }}</td>
                                <td>
                                    @php
                                        $typeLabels = [
                                            'absence' => 'Autre',
                                            'conge_individuel' => 'Congé payé',
                                            'conge_collectif' => 'Congé collectif'
                                        ];
                                    @endphp
                                    {{ $typeLabels[$absence->type] ?? $absence->category ?? 'N/A' }}
                                </td>
                                <td>{{ $absence->date_debut->format('d/m/Y') ?? '' }}</td>
                                <td>{{ $absence->date_fin ? $absence->date_fin->format('d/m/Y') : 'En cours' }}</td>
                                <td>{{ $absence->jours_absence ?? '' }}</td>
                                <td>
                                    @if($absence->statut === 'approved')
                                        <span class="badge badge-success">Approuvé</span>
                                    @elseif($absence->statut === 'rejected')
                                        <span class="badge badge-danger">Rejeté</span>
                                    @else
                                        <span class="badge badge-warning">En attente</span>
                                    @endif
                                </td>
                                <td>{{ $absence->reason ?? 'N/A' }}</td>
                                <td>
                                    <a href='{{ route("admin.edit-absence", $absence->id) }}' class="btn btn-sm btn-info"><i class="fas fa-edit"></i></a>
                                    <button class="btn btn-sm btn-danger delete" data-id="{{ $absence->id }}">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Updated Add Absence Modal -->
<div class="modal fade" id="addAbsenceModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Ajouter une Absence</h5>
                <button type="button" class="close" data-dismiss="modal">
                    <span>&times;</span>
                </button>
            </div>
            <form method="post" action="{{ route('admin.insert-absence') }}">
                @csrf
                <div class="modal-body">
                    <div class="form-group">
                        <label for="employee_id">Salarié</label>
                        <select class="form-control" name="employee_id" required>
                            <option value="">Sélectionner un salarié</option>
                            @foreach($employees as $employee)
                                <option value="{{ $employee->id }}">{{ $employee->name }} {{ $employee->prenom }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="type">Type d'absence</label>
                        <select class="form-control" name="type" required>
                            <option value="">Sélectionner un type</option>
                            <option value="absence">Autre</option>
                            <option value="conge_individuel">Congé payé</option>
                            <option value="conge_collectif">Congé collectif</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="date_debut">Date de début</label>
                        <input type="date" class="form-control" name="date_debut" required>
                    </div>

                    <div class="form-group">
                        <label for="date_fin">Date de fin</label>
                        <input type="date" class="form-control" name="date_fin" required>
                    </div>

                    <div class="form-group">
                        <label for="reason">Raison</label>
                        <textarea class="form-control" name="reason" rows="3"></textarea>
                    </div>

                    <div class="form-group">
                        <label for="statut">Statut</label>
                        <select class="form-control" name="statut">
                            <option value="pending">En attente</option>
                            <option value="approved">Approuvé</option>
                            <option value="rejected">Rejeté</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Fermer</button>
                    <button type="submit" class="btn btn-primary">Enregistrer</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
@section('script')
<script>
$(document).ready(function() {
    $('input[name="date_debut"]').on('change', function() {
        const startDate = this.value;
        const endDateInput = $('input[name="date_fin"]');
        
        // Set minimum end date to start date
        endDateInput.attr('min', startDate);
        
        // If end date is before start date, update it
        if (endDateInput.val() && endDateInput.val() < startDate) {
            endDateInput.val(startDate);
        }
    });
    
    $('input[name="date_fin"]').on('change', function() {
        const endDate = this.value;
        const startDate = $('input[name="date_debut"]').val();
        
        if (startDate && endDate < startDate) {
            this.setCustomValidity('La date de fin doit être après la date de début');
            this.reportValidity();
            return false;
        } else {
            this.setCustomValidity('');
        }
    });

    // Date validation for filter form
    $('input[name="start_date"]').on('change', function() {
        const startDate = this.value;
        const endDateInput = $('input[name="end_date"]');
        
        endDateInput.attr('min', startDate);
        
        if (endDateInput.val() && endDateInput.val() < startDate) {
            endDateInput.val(startDate);
        }
    });
    
    $('input[name="end_date"]').on('change', function() {
        const endDate = this.value;
        const startDate = $('input[name="start_date"]').val();
        
        if (startDate && endDate < startDate) {
            this.setCustomValidity('La date de fin doit être après la date de début');
            this.reportValidity();
            return false;
        } else {
            this.setCustomValidity('');
        }
    });

    $('.delete').click(function(){
	    
		var dataId = $(this).attr("data-id");
		Swal.fire({
		  title: "Are you sure?",
		  text: "Once you confirm, this action cannot be undone!",
		  icon: "warning",
		  showCancelButton: true,
		  confirmButtonColor: "#3085d6",
		  cancelButtonColor: "#d33",
		  confirmButtonText: "Yes, delete!"
		}).then((result) => {
		  if (result.isConfirmed) {
		    window.open(`{{ route("admin.delete-absence", [":dataId"]) }}`.replace(':dataId', dataId),"_self");
		  }
		});
	});
});
</script>




<script>
  $('#table1').DataTable({
    dom: 'Bfrtip',
    language: {
        url: '{{ asset("assets/fr-FR.json") }}'
    },
    pageLength: -1, // Show all rows by default
    lengthMenu: [ [10, 25, 50, -1], [10, 25, 50, "Tous"] ], // "All" translated to "Tous"
    paging: false, // Disable pagination to show all rows
    info: false, // Hide info like "Showing 1 to 10 of 50 entries"
    searching: true, // Keep search functionality
    ordering: true, // Keep sorting functionality
    buttons: [
        {
            title:'Liste des Absences',
            extend: 'copy',
            exportOptions: {
                columns: [0, 1, 2, 3, 4, 5, 6]
            }
        },
        {
            title:'Liste des Absences',
            extend: 'csv',
            exportOptions: {
                columns: [0, 1, 2, 3, 4, 5, 6]
            }
        },
        {
            title:'Liste des Absences',
            extend: 'excel',
            exportOptions: {
                columns: [0, 1, 2, 3, 4, 5, 6]
            }
        },
        {
            title:'Liste des Absences',
            extend: 'pdf',
            exportOptions: {
                columns: [0, 1, 2, 3, 4, 5, 6]
            }
        },
        {
            title: '<h2 style="text-align: center;">Liste des Absences</h2>',
            extend: 'print',
            exportOptions: {
                columns: [0, 1, 2, 3, 4, 5, 6]
            },
            customize: function (win) {
                $(win.document.body)
                    .css('font-size', '10pt')
                    .prepend(
                        '<div style="text-align: center;"><img src="{{ asset('assets/images/RenovImmo-long.png') }}" style="width: 80%; margin-bottom: 20px;" /></div>'
                    );
                $(win.document.body).find('h1').css('text-align', 'center').css('margin-bottom', '20px');
                $(win.document.body).find('table').addClass('table table-bordered table-striped');
            }
        },
        'colvis'
    ]
});
</script>


@endsection
