@extends('admin.layout')
@section('title')

{{$user->name }}

@endsection
@section('content')
<div class="dashboard-widg-bar d-block">
	<div class="row">
		<div class="col-xl-12 col-lg-12 col-md-12">
			<div class="_dashboard_content bg-white rounded mb-4" >
				
				<div class="_dashboard_content_body">
					<!-- Convershion -->

					<div class="messages-container margin-top-0">
						<div class="messages-headline">
							
							<h4> <div class="dash-msg-avatar">
								@if(isset($user->image))
								<img src="{{ asset('ayout/assets/avatars/'.'/'.$user->image) }}">
								@else
								<img src="{{ asset('layout/assets/avatars/user.jpg') }}">
								@endif
								{{ $user->name }}</div></h4>
								<a href="{{ route('employee.messages') }}" class=" btn message-action mt-4 "><i class="fa fa-reply mr-1"></i>Go Back</a>
							
						</div>

						<div class="messages-container-inner">

							<!-- Messages -->
							<div class="dash-msg-inbox">
								
								<div class="message-box">
									<ul class="chat-list">
										
									</ul>
								</div>
							</div>
							<!-- Messages / End -->

							<!-- Message Content  -->
							<div class="dash-msg-content">
								<div class="message-cont">
									
								</div>
								<!-- Reply Area -->
								<div class="clearfix"></div>
								<div class="message-reply">
									<input type="hidden" id="id"  name="id" value="{{ $user->id }}">
									<textarea cols="40" rows="3" class="form-control with-light emojitextarea" id="message"  name="message" placeholder="Your Message"></textarea>
									<input type="file" name="file" onchange="getname()" id="upload" style="display: none;" />
									<label for="upload" id="file-btn" class=" btn btn-primary mt-3 btn-rounded"><i class="fa fa-paperclip mr-1"></i>Choose File</label>
									<button id="send-message" class="btn btn-primary text-white">Send Message</button>
									
								</div>
								
							</div>
							<!-- Message Content -->

						</div>

					</div>
				</div>
			</div>
		</div>
	</div>
	<script>
		function getname(){
			name = $('#upload').val();
			string = name.split("\\");
			filename = string[string.length -1];
			if (filename.length > 7) {
				filename = filename.substring(0, 7) + "...";
			} 
			$('#file-btn').html(filename);
		}

		$('#send-message').click(function(){
		  var formData = new FormData();
		  var files = $('#upload')[0].files;
		  if (files.length > 0) {
		    var file = files[0];
		    formData.append('attachment', file);
		  }
		  formData.append('_token', '{{ csrf_token() }}');
		  formData.append('id', $('#id').val());
		  formData.append('message', $('#message').val());

		  $.ajax({
		    url: '{{ route("send-message") }}',
		    method: 'POST',
		    data: formData, 
		    processData: false, 
		    contentType: false,
		    success: function(responsedata) {
		      var messageDiv = $('.message-cont');
		      var scrollHeight = messageDiv.prop('scrollHeight');
		      messageDiv.scrollTop(scrollHeight);
		      $('#message').val(' ');
		      $('.emojionearea-editor').html('');
		      $('#upload').val('');
		      $('#file-btn').html('<i class="fa fa-paperclip mr-1"></i>Choose File');
		    },
		    error: function(xhr, status, error) {
		    }
		  });
		});

		var i =0;
		setInterval(function(){
			$.ajax({
				url: "{{ route('get-messages') }}",
				method:'POST',
				data:{
					'_token':'{{ csrf_token() }}',
					'id':$('#id').val(),
				},
				success:function(response){
					var id = $('#id').val();
					$('.message-cont').html(response);
					var messageDiv = $('.message-cont');
	    			var scrollHeight = messageDiv.prop('scrollHeight');
	    			messageDiv.scrollTop(scrollHeight);
				}
			})
		},900);
		setInterval(function(){
			$.ajax({
				url: "{{ route('get-chats') }}",
				method:'POST',
				data:{
					'_token':'{{ csrf_token() }}',
					'id':$('#id').val(),
				},
				success:function(response){
					$('.chat-list').html(response);
				}
			})
		},900);
		
	</script>
</div>
@endsection