@extends('admin.layout')
@section('title') Add Product @endsection
@section('content')

<div class="page-title">
    <div class="row mb-3">
        <div class="col-12 col-md-6 order-md-1 order-last">
            <h3>Add Product</h3>
        </div>
        <div class="col-12 col-md-6 order-md-2 order-first">
            <nav aria-label="breadcrumb" class="breadcrumb-header float-start float-lg-end">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="./">Dashboard</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Add Product
                    </li>
                </ol>
            </nav>
        </div>
    </div>
</div>


<div class="row">
	<div class="col-">
                    <div class="row match-height">
                        
                        <div class="col-md-12 col-12">
                            <div class="card">
                                <div class="card-content">
                                    <div class="card-body">
                                        <form method="post" action="{{ route('admin.insert-product') }}"  enctype="multipart/form-data">
                                        @csrf
                                            <div class="form-body">
                                                <div class="row">
                                                    <div class="col-md-3">
                                                        <label class="jblack-text-color"><strong>Title</strong></label>
                                                    </div>
                                                    <div class="col-md-9" width="100%">
                                                        <div class="form-group has-icon-left">
                                                            <div class="position-relative">
                                                            <input type="text" class="form-control" 
                                                                    placeholder="Product Title"
                                                                    name="name" id="name" required>
                                                                <div class="form-control-icon">
                                                                <i class="fa-solid fa-box"></i>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-3">
                                                        <label class="jblack-text-color"><strong>Price</strong></label>
                                                    </div>
                                                    <div class="col-md-9" width="100%">
                                                        <div class="form-group has-icon-left">
                                                            <div class="position-relative">
                                                                <input type="number" class="form-control" 
                                                                    placeholder="Product Price"
                                                                    name="price" id="price">
																<div class="form-control-icon">
                                                                    <i class="fa-solid fa-money-bill"></i>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-3">
                                                        <label class="jblack-text-color"><strong>Sell Price</strong></label>
                                                    </div>
                                                    <div class="col-md-9" width="100%">
                                                        <div class="form-group has-icon-left">
                                                            <div class="position-relative">
                                                                <input type="number" class="form-control" 
                                                                    placeholder="Selling Price"
                                                                    name="sell_price" id="sell_price">
																<div class="form-control-icon">
                                                                    <i class="fa-solid fa-money-bill-alt"></i>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-3">
                                                        <label class="jblack-text-color pt-2"><strong>Status </strong></label>
                                                    </div>
                                                    <div class="col-md-9" width="100%">
                                                        <div class="form-group has-icon-left">
                                                            <div class="position-relative">
                                                                <fieldset class="form-control form-group">
																	<select class="form-select"  name="status" style="width:100%;" data-placeholder="Status" id="status" required>
																		<option value=" "> Select Status</option>
																		<option value="Available">Available</option>
																		<option value="Out of Stock">Out of Stock</option>
																	</select>
																</fieldset>
																<div class="form-control-icon">
                                                                    <i class="bi bi-check-square"></i>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>


                                                    <div class="col-md-3">
                                                        <label class="jblack-text-color pt-2"><strong>Product Packs </strong></label>
                                                    </div>
                                                    <div class="col-md-9" width="100%">
                                                        <div class="form-group has-icon-left">
                                                            <div class="position-relative">
                                                                <fieldset class="form-control form-group">
                                                                    
                                                                    <select class="choices form-select" multiple="multiple">
																		<option  value="FREE TRIAL" >FREE TRIAL (0 DH)</option>
																		<option  value="STARTER PACK" >STARTER PACK (1000 DH)</option>
																		<option  value="STANDARD PACK" >STANDARD PACK (2000 DH)</option>
																		<option  value="PREMIUM PACK" >PREMIUM PACK (3000 DH)</option>
                                                                    </select>
																</fieldset>
																<div class="form-control-icon">
                                                                    <i class="bi bi-check-square"></i>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    


                                                    <div class="col-md-3">
                                                        <label class="jblack-text-color pt-2"><strong>Product Image </strong></label>
                                                    </div>
                                                    <div class="col-md-9" width="100%">
                                                        <div class="form-group has-icon-left">
                                                            <div class="position-relative">
																
                                                                <div class="card-content">
																<div class="card-">
																	<input type="file" name="media" class="image-preview-filepond">
																</div>
															</div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    

                                                    <div class="col-md-3">
                                                        <label class="jblack-text-color"><strong>Description</strong></label>
                                                    </div>
                                                    <div class="col-md-9" width="100%">
                                                        <div class="form-group has-icon-left">
                                                            <div class="position-relative">
                                                                <textarea class="form-control" style="width:100%;"  id="description" name="description" 
                                                            rows="3"></textarea>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-12 d-flex justify-content-end">
                                                        <button type="submit" class="btn btn-block btn-xl btn-primary font-bold m-3">Add Product</button>
                                                        <button type="reset" class="btn btn-block btn-xl btn-light-primary font-bold m-3">Reset</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                <br><br>
	</div>
	
</div>


@endsection
@section('script')

<script src="{{ asset('assets/vendors/ckeditor/ckeditor.js') }}"></script>
    <script>
        ClassicEditor
            .create(document.querySelector('#description'))
            .catch(error => {
                console.error(error);
            });
    </script>
<!-- <script>
    CKEDITOR.replace('description');
</script> -->

<script>
    $('.drgpicker').daterangepicker({
        singleDatePicker: true,
        timePicker: true,
        showDropdowns: true,
        locale:
        {
          format: 'DD/MM/YYYY HH:mm'
        }
    });
</script>


<script>
    $(document).ready(function() {
    $('button[type="reset"]').click(function(event) {
        event.preventDefault(); // Prevent the default reset behavior

        // Clear all input fields
        $('input[type="text"], input[type="number"],input[type="email"],input[type="int"],input[type="password"],input[type="phone"], textarea').val('');

        // Reset file input
        $('input[type="file"]').val('');

        // Reset select dropdowns to the first option
        $('select').prop('selectedIndex', 0);
        
        // Reset any custom file input preview or other custom states (if applicable)
        $('.image-preview-filepond').filepond('clear');
    });
});
</script>
@endsection