@extends('admin.layout')
@section('title') Affectation des Matériels @endsection
@section('content')

<div class="intro-y mb-3 flex items-center">
	<div class="row">
		<div class="col-8 mb-4 mb-xl-0">
		    <h2 class="mr-auto text-lg font-medium">Affectation des Matériels</h2>
		</div>

		<div class="col-4">
			<div class="justify-content-end d-flex">
				<a href="{{ route('admin.materiels') }}" class="btn btn-primary mr-2">
                    <i class="fa fa-arrow-left"></i> Retour aux Matériels
                </a>

				<a href="{{ route('admin.affectation-materiel-salarie') }}" class="btn btn-primary mr-2">Affectation Salarié</a>
			</div>			 
		</div>
	</div>
</div>

<br>

<div class="row">
    <div class="col-md-12 grid-margin stretch-card">
        <div class="card">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped table-borderless datatables" id="table1">
                        <thead>
                            <tr>
                                <th></th>
                                <th>Photo</th>
                                <th>Matériel</th>
                                <th>Référence</th>
                                <th>Salarié</th>
                                <th>Date d'affectation</th>
                                <th>Date de remise</th>
                                <th>Date de retour</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>  
                        </thead>
                        <tbody>
                            <?php $i=1; ?>
                            @foreach($affectations as $affectation)
                            @php 
                                $materiel = \App\Models\Materiel::find($affectation->materiel_id);
                                $salarie = \App\Models\User::find($affectation->salarie_id);
                            @endphp
                            <tr>
                                <td>{{ $i++ }}</td>
                                <td>
                                    @if($materiel->photo)
                                        @php $photos = json_decode($materiel->photo); @endphp
                                        @if(!empty($photos))
                                            @foreach($photos as $photo)
                                                @if(file_exists(public_path('uploads/' . $photo)))
                                                    <img src="{{ asset('uploads/' . $photo) }}" alt="Photo" class="rounded" height="50" width="50"/>
                                                    @break
                                                @else
                                                    <img src="{{ asset('assets/images/no_image.png') }}" alt="No Image" class="rounded" height="50" width="50"/>
                                                    @break
                                                @endif
                                            @endforeach
                                        @else
                                            <img src="{{ asset('assets/images/no_image.png') }}" alt="No Image" class="rounded" height="50" width="50"/>
                                        @endif
                                    @else
                                        <img src="{{ asset('assets/images/no_image.png') }}" alt="No Image" class="rounded" height="50" width="50"/>
                                    @endif
                                </td>
                                <td class="font-weight-bold">
                                    @if($materiel)
                                        {{ $materiel->materiel ?? '' }}
                                    @else
                                        <span class="text-muted">Matériel supprimé</span>
                                    @endif
                                </td>
                                <td class="font-weight-bold">
                                    @if($materiel->reference)
                                        {{ $materiel->reference ?? '' }}
                                    @else
                                        <span class="text-muted">Aucun</span>
                                    @endif
                                </td>
                                <td class="font-weight-bold">
                                    @if($salarie)
                                    {{ $salarie->prenom ?? '' }} {{ $salarie->name ?? '' }}
                                    @else
                                        <span class="text-muted">Salarié supprimé</span>
                                    @endif
                                </td>
                                <td>{{ \Carbon\Carbon::parse($affectation->date_de_prise)->format('d/m/Y') ?? '' }}</td>
                                <td>{{ \Carbon\Carbon::parse($affectation->date_de_remise)->format('d/m/Y') ?? '' }}</td>
                                <td>
                                    @if($affectation->date_retour)
                                        {{ \Carbon\Carbon::parse($affectation->date_retour)->format('d/m/Y') ?? '' }}
                                    @else
                                        <span class="badge bg-warning text-white">En cours</span>
                                    @endif
                                </td>
                                <td>
                                    @if($affectation->status == 'returned')
                                        <span class="badge bg-success text-white">Retourné</span>
                                    @else
                                        <span class="badge bg-primary text-white">Affecté</span>
                                    @endif
                                </td>
                                <td>
                                    @if($affectation->status != 'returned')
                                        <a href="javascript:void(0);" class="text-success return-materiel" data-id="{{ $affectation->id }}">
                                            <i class="fa fa-check-circle"></i> Marquer comme retourné
                                        </a>
                                    @endif
                                    <a data-id="{{ $affectation->id }}" class="text-danger delete" href="javascript:void(0);">
                                        <i class="fa-solid fa-trash"></i> Supprimer
                                    </a>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@section('script')
<script>
   

    // Delete affectation
    $('.delete').click(function(){
        var dataId = $(this).attr("data-id");
        Swal.fire({
            title: "Êtes-vous sûr?",
            text: "Une fois que vous confirmez, cette action ne peut plus être annulée!",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "Oui, supprimer!",
            cancelButtonText: "Annuler"
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = "/admin/delete-affectation/"+dataId;
            }
        });
    });

    // Return materiel
    $('.return-materiel').click(function(){
        var dataId = $(this).attr("data-id");
        Swal.fire({
            title: "Confirmer le retour",
            text: "Voulez-vous marquer ce matériel comme retourné?",
            icon: "question",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "Oui, confirmer",
            cancelButtonText: "Annuler"
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = "{{ route('admin.return-materiel', '') }}/" + dataId;
            }
        });
    });
</script>



<script>
  $('#table1').DataTable({
        dom: 'Bfrtip',
        language: {
            url: '{{ asset("assets/fr-FR.json") }}'
        },
        buttons: [
            {
				title:'Affectation des Matériels',
                extend: 'copy',
                exportOptions: {
                    columns: [0, 2, 3, 4, 5, 6, 7, 8]
                }
            },
            {
				title:'Affectation des Matériels',
                extend: 'csv',
                exportOptions: {
                    columns: [0, 2, 3, 4, 5, 6, 7, 8]
                }
            },
            {
				title:'Affectation des Matériels',
                extend: 'excel',
                exportOptions: {
                    columns: [0, 2, 3, 4, 5, 6, 7, 8]
                }
            },
            {
				title:'Affectation des Matériels',
                extend: 'pdf',
				text: 'PDF',
                exportOptions: {
					modifier: {
                    page: 'current'
                },
                    columns: [0, 2, 3, 4, 5, 6, 7, 8]
                }
            },
            {
				title: '<h2 style="text-align: center;">Affectation des Matériels</h2>', // Title centered
				extend: 'print',
				exportOptions: {
					columns: [0, 2, 3, 4, 5, 6, 7, 8]
				},
				customize: function (win) {
					$(win.document.body)
						.css('font-size', '10pt') // Optional: Adjust font size
						.prepend(
							'<div style="text-align: center;"><img src="{{ asset('assets/images/RenovImmo-long.png') }}" style="width: 80%; margin-bottom: 20px;" /></div>'
						);

					// Style the title
					$(win.document.body).find('h1')
						.css('text-align', 'center') // Ensure the title is centered
						.css('margin-bottom', '20px'); // Optional: Add spacing below the title
						
						
					// Style the table explicitly
					$(win.document.body).find('table').addClass('table table-bordered table-striped');
				}
			},

            'colvis'
        ]
    });
</script>


@endsection
