@extends('admin.layout')
@section('title') Modifier Absence @endsection
@section('content')

<style>
    .select2-container--default .select2-selection--single {
        height: 50px;
    }
</style>
<div class="row">
    <div class="col-lg-12 grid-margin stretch-card">
        <div class="card">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h4 class="card-title">Modifier Absence</h4>
                    <a href="{{ route('admin.absences') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-left"></i> Retour
                    </a>
                </div>

                <form class="forms-sample" method="POST" action="{{ route('admin.update-absence') }}">
                    @csrf
                    <input type="hidden" name="absence_id" value="{{ $absence->id }}">
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="employee_id">Salarié</label>
                                <select class="form-control" name="employee_id" style="min-height: 40px;" required>
                                    @foreach($employees as $employee)
                                        <option value="{{ $employee->id }}" {{ $absence->employee_id == $employee->id ? 'selected' : '' }}>
                                            {{ $employee->name }} {{ $employee->prenom }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="type">Type d'absence</label>
                                <select class="form-control" name="type" required>
                                    <option value="absence" {{ $absence->type == 'absence' ? 'selected' : '' }}>Autre</option>
                                    <option value="conge_individuel" {{ $absence->type == 'conge_individuel' ? 'selected' : '' }}>Congé individuel</option>
                                    <option value="conge_collectif" {{ $absence->type == 'conge_collectif' ? 'selected' : '' }}>Congé collectif</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="date_debut">Date de début</label>
                                <input type="date" class="form-control" name="date_debut" id="date_debut" 
                                       value="{{ $absence->date_debut ? $absence->date_debut->format('Y-m-d') : '' }}" required>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="date_fin">Date de fin</label>
                                <input type="date" class="form-control" name="date_fin" id="date_fin" 
                                       value="{{ $absence->date_fin ? $absence->date_fin->format('Y-m-d') : '' }}" 
                                       min="{{ $absence->date_debut ? $absence->date_debut->format('Y-m-d') : '' }}" required>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="statut">Statut</label>
                                <select class="form-control" name="statut" required>
                                    <option value="pending" {{ $absence->statut == 'pending' ? 'selected' : '' }}>En attente</option>
                                    <option value="approved" {{ $absence->statut == 'approved' ? 'selected' : '' }}>Approuvé</option>
                                    <option value="rejected" {{ $absence->statut == 'rejected' ? 'selected' : '' }}>Rejeté</option>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="jours_absence">Jours d'absence (calculé automatiquement)</label>
                                <input type="text" class="form-control" value="{{ $absence->jours_absence }}" readonly>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="reason">Raison/Motif</label>
                                <textarea class="form-control" name="reason" rows="4" placeholder="Décrivez la raison de l'absence...">{{ $absence->reason }}</textarea>
                            </div>
                        </div>
                    </div>

                    <div class="mt-4">
                        <button type="submit" class="btn btn-primary mr-2">
                            <i class="fas fa-save"></i> Enregistrer
                        </button>
                        <a href="{{ route('admin.absences') }}" class="btn btn-light">
                            <i class="fas fa-times"></i> Annuler
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

@endsection

@section('script')
<script>
$(document).ready(function() {
    // Date validation
    $('#date_debut').on('change', function() {
        const startDate = this.value;
        const endDateInput = $('#date_fin');
        
        // Set minimum end date to start date
        endDateInput.attr('min', startDate);
        
        // If end date is before start date, update it
        if (endDateInput.val() && endDateInput.val() < startDate) {
            endDateInput.val(startDate);
        }
    });
    
    $('#date_fin').on('change', function() {
        const endDate = this.value;
        const startDate = $('#date_debut').val();
        
        if (startDate && endDate < startDate) {
            this.setCustomValidity('La date de fin doit être après la date de début');
            this.reportValidity();
            return false;
        } else {
            this.setCustomValidity('');
        }
    });

    // Initialize select2 if available
    if ($.fn.select2) {
        $('select[name="employee_id"]').select2({
            placeholder: "Sélectionner un salarié",
            width: '100%'
        });
    }
});
</script>
@endsection