@extends('admin.layout')
@section('title') Modifier Admin @endsection
@section('content')


<div class="intro-y mt-8 flex items-center">
    <h2 class="mr-auto text-lg font-medium">Mettre a jour Admin</h2>
</div>


<div class="card">
    <div class="card-body">
        
        <form method="post" enctype="multipart/form-data" autocomplete="off" action="{{ route('admin.update-admin') }}">
        	@csrf
        	<input type="hidden" name="id" value="{{ $admin->id ?? '' }}">

            <div class="form-group">
                <label for="name">Nom <strong class="text-danger">*</strong></label>
                <input name="name" id="name" type="text" class="form-control" value="{{ $admin->name ?? '' }}" required>
            </div>

            <div class="form-group">
                <label for="prenom">Prénom <strong class="text-danger">*</strong></label>
                <input name="prenom" id="prenom" type="text" class="form-control" value="{{ $admin->prenom ?? '' }}" required>
            </div>

            <div class="form-group">
                <label for="email">Email <strong class="text-danger">*</strong></label>
                <input name="email" id="email" type="email" class="form-control"  value="{{ $admin->email ?? '' }}" required>
            </div>

            <div class="form-group">
                <label for="password">Mot de passe <strong class="text-danger">*</strong></label>
                <input name="password" id="password" type="password" class="form-control" value="{{ $admin->password ?? '' }}" required>
            </div>
            
            <button type="submit" class="btn btn-primary mr-2">Mettre à jour</button>
            <button type="reset" class="btn btn-light">Réinitialiser</button>
        </form>
    </div>
</div>




@endsection
@section('script')

<script>
    $(document).ready(function() {
    $('button[type="reset"]').click(function(event) {
        event.preventDefault(); // Prevent the default reset behavior

        // Clear all input fields
        $('input[type="text"], input[type="number"],input[type="email"],input[type="int"],input[type="password"],input[type="phone"], textarea').val('');

        // Reset file input
        $('input[type="file"]').val('');

        // Reset select dropdowns to the first option
        $('select').prop('selectedIndex', 0);
        
        // Reset any custom file input preview or other custom states (if applicable)
        $('.image-preview-filepond').filepond('clear');
    });
});
</script>

@endsection

