@extends('admin.layout')
@section('title') Edit Salarié @endsection
@section('content')


<div class="intro-y mt-8 flex items-center">
    <h2 class="mr-auto text-lg font-medium">Mettre a jour Salarié</h2>
</div>


<div class="card">
    <div class="card-body">
        
        <form method="post" enctype="multipart/form-data" autocomplete="off" action="{{ route('admin.update-employee') }}">
        @csrf
        <input type="hidden" name="employee" value="{{ $current_employee->id }}">
            <div class="form-group">
                <label for="name">Nom <strong class="text-danger">*</strong></label>
                <input name="name" id="name" type="text" class="form-control"  value="{{ $current_employee->name ?? '' }}" required>
            </div>
            <div class="form-group">
                <label for="prenom">Prénom <strong class="text-danger">*</strong></label>
                <input name="prenom" id="prenom" type="text" class="form-control"  value="{{ $current_employee->prenom ?? '' }}" required>
            </div>

            <div class="form-group">
                <label for="email">Email <strong class="text-danger">*</strong></label>
                <input name="email" id="email" type="email" class="form-control"  value="{{ $current_employee->email ?? '' }}" required>
            </div>

            <div class="form-group">
                <label for="phone">Téléphone <strong class="text-danger">*</strong></label>
                <input name="phone" id="phone" type="text" class="form-control"  value="{{ $current_employee->phone ?? '' }}" required>
            </div>


            <div class="form-group">
                <label for="password">Mot de passe <strong class="text-danger">*</strong></label>
                <input name="password" id="password" type="text" class="form-control"  value="{{ $current_employee->password ?? '' }}" required>
            </div>


            <div class="form-group">
                <label for="adresse">Adresse</label>
                <input name="adresse" id="adresse" type="text" class="form-control"  value="{{ $current_employee->adresse ?? '' }}">
            </div>

            <div class="form-group">
                <label for="primary_metiers">Metiers</label>
                <br>
                <select id="primary_metiers" name="primary_metiers[]" class="js-example-basic-multiple form-control  w-100" multiple="multiple">
                @foreach($metiers as $primary_metier)
                    <option value="{{ $primary_metier->id ?? '' }}" 
                        <?php echo (in_array($primary_metier->id, json_decode($current_employee->primary_metiers) ?? [])) ? 'selected' : ''; ?>>
                        {{ $primary_metier->nom }}
                    </option>
                @endforeach
                </select>
            </div>



            <div class="form-group">
                <label for="secondary_metiers">Métiers secondaire</label>
                <br>
                <select id="secondary_metiers" name="secondary_metiers[]" class="js-example-basic-multiple form-control  w-100" multiple="multiple">
                @foreach($metiers as $secondary_metier)
                    <option value="{{ $secondary_metier->id ?? '' }}" 
                        <?php echo (in_array($secondary_metier->id, json_decode($current_employee->secondary_metiers) ?? [])) ? 'selected' : ''; ?>>
                        {{ $secondary_metier->nom }}
                    </option>
                @endforeach
                </select>
            </div>


            <div class="form-check">
                <label class="form-check-label ">
                    <input type="checkbox" name="is_couvreur" id="is_couvreur" class="form-check-input" <?php echo ($current_employee->is_couvreur == 1) ? 'checked' : ''; ?>>
                    Couvreur
                    <i class="input-helper"></i>
                </label>
            </div>


            <div class="form-group">
                    <label for="photos">Photo</label>
                    <div class="d-flex flex-wrap mb-2">
                    
						@if($current_employee->image)
							
                                    @if( file_exists(public_path('media/' . $current_employee->image)) )
                                        <img src="{{ asset('media/' . $current_employee->image) }}" alt="Photo" class="rounded mr-1" height="200" width="auto"/>
                                    @else
                                        <img src="{{ asset('assets/images/no_image.png') }}" alt="No Image" class="rounded mr-1" height="200" width="auto"/>
                                    @endif
                                
						@else
							<img src="{{ asset('assets/images/no_image.png') }}" alt="No Images" class="rounded" height="200" width="auto"/>
						@endif
                </div>
            
            <input type="file" name="image" multiple class="image-preview-filepond filepond" id="photo-input">
            <div id="photo-preview" class="d-flex flex-wrap mt-2"></div> <!-- Preview container -->
        </div>


            
            
            <button type="submit" class="btn btn-primary mr-2">Mettre à jour</button>
            <button type="reset" class="btn btn-light">Réinitialiser</button>
        </form>
    </div>
</div>




@endsection
@section('script')

<script>
    $(document).ready(function() {
    $('button[type="reset"]').click(function(event) {
        event.preventDefault(); // Prevent the default reset behavior

        // Clear all input fields
        $('input[type="text"], input[type="number"],input[type="email"],input[type="int"],input[type="password"],input[type="phone"], textarea').val('');

        // Reset file input
        $('input[type="file"]').val('');

        // Reset select dropdowns to the first option
        $('select').prop('selectedIndex', 0);
        
        // Reset any custom file input preview or other custom states (if applicable)
        $('.image-preview-filepond').filepond('clear');
    });
});
</script>

@endsection

