@extends('admin.layout')
@section('title') Modifier Lieu @endsection
@section('content')


<style>

.img-Lieu {
    width: auto;
}
</style>


<div class="page-title">
    <div class="row mb-3">
        <div class="col-12 col-md-6 order-md-1 order-last">
        <h2 class="mr-auto text-lg font-medium">Modifier Lieu</h2>
        </div>
        <div class="col-12 col-md-6 order-md-2 order-first">
            <nav aria-label="breadcrumb" class="breadcrumb-header float-start float-lg-end">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="/">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="/admin/lieux">Lieux</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Ajouter Lieu
                    </li>
                </ol>
            </nav>
        </div>
    </div>
</div>



<div class="card">
    <div class="card-body">
        
        <form method="post" enctype="multipart/form-data" autocomplete="off" action="{{ route('admin.update-lieu') }}">
        @csrf
        <input type="hidden" name="id" value="{{ $lieu->id }}">
        <div class="form-group">
            <label for="nom">Lieu</label>
            <input name="lieu" id="lieu" value="{{ $lieu->lieu ?? '' }}" type="text" class="form-control" required>
        </div>
        


        <div class="form-group">
                <label for="photos">Images</label>
                <div class="d-flex flex-wrap mb-2">
                    
						@if($lieu->photo)
							@php $photos = json_decode($lieu->photo); @endphp
                            @if(!empty($photos))

                                @foreach($photos as $photo)

                                    @if( file_exists(public_path('uploads/' . $photo)) )
                                        <img src="{{ asset('uploads/' . $photo) }}" alt="Photo" class="rounded mr-1" height="200" width="auto"/>
                                    @else
                                        <img src="{{ asset('assets/images/no_image.png') }}" alt="No Image" class="rounded mr-1" height="200" width="auto"/>
                                    @endif
                                @endforeach
                            @endif
						@else
							<img src="{{ asset('assets/images/no_image.png') }}" alt="No Images" class="rounded" height="200" width="auto"/>
						@endif
                </div>
            
            <input type="file" name="photo[]" multiple class="image-preview-filepond filepond" id="photo-input">
            <div id="photo-preview" class="d-flex flex-wrap mt-2"></div> <!-- Preview container -->
        </div>


            
        
        <button type="submit" class="btn btn-primary mr-2">Mettre à jour</button>
        <button type="reset" class="btn btn-light">Réinitialiser</button>
        </form>
    </div>
</div>

@endsection



@section('script')
<script>
    document.getElementById('photo-input').addEventListener('change', function(event) {
        const previewContainer = document.getElementById('photo-preview');
        previewContainer.innerHTML = ''; // Clear previous previews

        const files = event.target.files;
        for (let i = 0; i < files.length; i++) {
            const file = files[i];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    const img = document.createElement('img');
                    img.src = e.target.result;
                    img.alt = 'Preview';
                    img.className = 'img-lieu rounded mr-2 mb-2';
                    img.height = 200; // Set height to 200
                    img.width = 200; // Set width to auto
                    previewContainer.appendChild(img); // Append to preview container
                }
                reader.readAsDataURL(file); // Read the file as a data URL
            }
        }
    });
</script>
@endsection