@extends('admin.layout')
@section('title') Demandes d'Éléments @endsection
@section('content')

<div class="intro-y mb-3 flex items-center">
    <div class="row">
        <div class="col-8 mb-4 mb-xl-0">
            <h2 class="mr-auto text-lg font-medium">Historique Stock</h2>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-12 grid-margin stretch-card">
        <div class="card">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped table-borderless datatables" id="table1">
                        <thead>
                            <tr>
                                <th></th>
                                <th>Employé</th>
                                <th>Élément</th>
                                <th>Quantité</th>
                                <th>Raison</th>
                                <th>Date</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $i=1; ?>
                            @foreach($requests as $request)
                            <tr>
                                <td>{{ $i++ }}</td>
                                <td>{{ $request->employee->prenom }} {{ $request->employee->name }}</td>
                                <td>{{ $request->element->element }}</td>
                                <td>{{ $request->quantity_requested }}</td>
                                <td>{{ $request->reason ?? '-' }}</td>
                                <td>{{ $request->created_at->format('d/m/Y H:i') }}</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Reject Modal -->
<div class="modal fade" id="rejectModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="{{ route('admin.reject-element-request') }}" method="POST">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title">Rejeter la Demande</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="request_id" id="reject_request_id">
                    <div class="mb-3">
                        <label>Notes Admin (Optionnel):</label>
                        <textarea name="admin_notes" class="form-control" rows="3"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Annuler</button>
                    <button type="submit" class="btn btn-danger">Rejeter</button>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection

@section('script')
<script>
$('.approve-btn').click(function(e){
    e.preventDefault();
    var url = $(this).attr('href');
    
    Swal.fire({
        title: "Approuver la demande?",
        text: "Cette action déduira la quantité du stock.",
        icon: "question",
        showCancelButton: true,
        confirmButtonText: "Oui, approuver",
        cancelButtonText: "Annuler"
    }).then((result) => {
        if (result.isConfirmed) {
            window.location.href = url;
        }
    });
});

$('.reject-btn').click(function(){
    var requestId = $(this).data('id');
    $('#reject_request_id').val(requestId);
    $('#rejectModal').modal('show');
});

$('#table1').DataTable();
</script>
@endsection