@extends('admin.layout')
@section('title') Gestion des Elements @endsection
@section('content')

<div class="intro-y  mb-3 flex items-center">
	<div class="row">
		<div class="col-8 mb-4 mb-xl-0">
		    <h2 class="mr-auto text-lg font-medium">Gestion des Elements</h2>
		</div>
		<div class="col-4">
			<div class="justify-content-end d-flex">
				<a href="{{ route('admin.add-element') }}" class="btn btn-primary mr-2">Ajouter Element</a>
			</div>			 
		</div>
	</div>
</div>

<br>

<div class="row">
    <div class="col-md-12 grid-margin stretch-card">
        <div class="card">
        <div class="card-body">
            <div class="table-responsive">
            <table class="table table-striped table-borderless datatables" id="table1">
                <thead>
                <!-- TOTAL ROW IN HEADER -->
                <tr class="bg-primary text-white">
                    <th colspan="7" style="text-align: right; font-size: 16px; padding: 15px;">
                        <i class="fas fa-calculator"></i> Prix Total de Stock:
                    </th>
                    <th style="font-size: 16px; padding: 15px;">
                        <strong>
                            € {{ number_format($elements->sum(function($element) { 
                                return ($element->prix_achat ?? 0) * ($element->quantity ?? 0); 
                            }), 2, ',', ' ') }}
                        </strong>
                    </th>
                    <th></th>
                </tr>
                <!-- REGULAR HEADERS -->
                <tr>
                    <th></th>
                    <th>Image</th>
                    <th>Element</th>
                    <th>Famille</th>
                    <th>Alerte Qte</th>
                    <th>Qte</th>
                    <th>Prix d'achat</th>
                    <th>Prix Total</th>
                    <th style="text-align:right;">Action</th>
                </tr>  
                </thead>
                <tbody>
                <?php $i=1; ?>
                @foreach($elements as $element)
	              <tr class="{{ $element->quantity < $element->stock_alert ? 'table-danger' : '' }}">
	                <td>{{ $i++ }}</td>
                    <td>
                        @if($element->photo)
							@php $photos = json_decode($element->photo); @endphp
							@if(!empty($photos) && isset($photos[0]) && file_exists(public_path('uploads/' . $photos[0])))
								<img src="{{ asset('uploads/' . $photos[0]) }}" alt="Photo" class="img-fluid rounded" height="200" width="auto"/>
							@else
								<img src="{{ asset('assets/images/no_image.png') }}" alt="No Image" class="img-fluid rounded" height="200" width="auto"/>
							@endif
						@else
							<img src="{{ asset('assets/images/no_image.png') }}" alt="No Images" class="img-fluid rounded" height="200" width="auto"/>
						@endif
                    </td>
	                <td class="font-weight-bold" style="max-width: 200px; white-space: normal; word-wrap: break-word;">{{ $element->element ?? '' }}</td>
					<td class="font-weight-bold">
						@php 
						$famille = \App\Models\Famille::find($element->familleId);
						@endphp
						@if($famille)
							<span class='badge badge-primary text-white mr-1'>{{ $famille->nom ?? '' }}</span>
						@endif
					</td>	                
					<td>{{ $element->stock_alert ?? '' }}</td>
					<td class="font-weight-bold">{{ $element->quantity ?? 'N/A' }}</td>
	                <td class="font-weight-bold" data-prix="{{ $element->prix_achat ?? 0 }}">€ {{ number_format($element->prix_achat ?? 0, 2, ',', ' ') }}</td>
					<td class="font-weight-bold prix-total" data-total="{{ ($element->prix_achat ?? 0) * ($element->quantity ?? 0) }}">
                        € {{ number_format(($element->prix_achat ?? 0) * ($element->quantity ?? 0), 2, ',', ' ') }}
                    </td>
	                <td style="text-align:right;">
						<a href="{{ route('admin.stock-movement', ['id' => $element->id]) }}" class="text-success mr-2"><i class="fa-solid fa-cubes-stacked"></i> Gérer le Stock</a>
						<a href="{{ route('admin.edit-element', ['id' => $element->id]) }}" class="text-info  mr-2"><i class="fa-solid fa-pen-to-square"></i> Modifier</a>
						<a href="{{ route('admin.delete-element', ['id' => $element->id]) }}" class="text-danger delete" onclick="return confirm('Êtes-vous sûr de vouloir supprimer cet élément?')"><i class="fa-solid fa-trash"></i> Supprimer</a>
					</td>
	              </tr>
	              @endforeach
                </tbody>
            </table>
            </div>
        </div>
        </div>
    </div>
</div>

@endsection

@section('script')

<script>
	$('.delete').click(function(){
		var dataId = $(this).attr("data-id");
		Swal.fire({
		  title: "Êtes-vous sûr?",
		  text: "Une fois que vous confirmez, cette action ne peut plus être annulée!",
		  icon: "warning",
		  showCancelButton: true,
		  confirmButtonColor: "#3085d6",
		  cancelButtonColor: "#d33",
		  confirmButtonText: "Oui, supprime-le!"
		}).then((result) => {
		  if (result.isConfirmed) {
		    Swal.fire({
		      title: "Supprimé!",
		      text: "La suppression est réussie.",
		      icon: "success"
		    });
		    window.open("{{ route('admin.delete-element', ['id' => 'dataId']) }}".replace('dataId', dataId),"_self");
		  }
		});
	});
</script>

<script>
  $('#table1').DataTable({
		dom: 'Bfrtip',
		language: {
			url: '{{ asset("assets/fr-FR.json") }}'
		},
		pageLength: -1,
		lengthMenu: [ [10, 25, 50, -1], [10, 25, 50, "Tous"] ],
		paging: false,
		info: false,
		searching: true,
		ordering: true,
        buttons: [
            {
				title:'Liste des Elements',
                extend: 'copy',
                exportOptions: {
                    columns: [0, 2, 3, 4, 5, 6, 7],
                    orthogonal: 'export',
                    format: {
                        body: function (data, row, column, node) {
                            // Strip HTML tags from all columns first
                            var stripped = $('<div>').html(data).text();
                            
                            // For Prix d'achat (column 6) and Prix Total (column 7)
                            if (column === 6 || column === 7) {
                                var value = $(node).data('prix') || $(node).data('total');
                                if (value !== undefined) {
                                    return parseFloat(value).toFixed(2).replace('.', ',');
                                }
                            }
                            
                            return stripped;
                        }
                    }
                }
            },
            {
				title:'Liste des Elements',
				extend: 'csv',
				charset: 'utf-8',
				bom: true,
				fieldSeparator: ';',
				exportOptions: {
					columns: [0, 2, 3, 4, 5, 6, 7],
					orthogonal: 'export',
					format: {
						body: function (data, row, column, node) {
							// Strip HTML tags from all columns first
							var stripped = $('<div>').html(data).text();
							
							// For Prix d'achat (column 6) and Prix Total (column 7)
							if (column === 6 || column === 7) {
								var value = $(node).data('prix') || $(node).data('total');
								if (value !== undefined) {
									return parseFloat(value).toFixed(2).replace('.', ',');
								}
							}
							
							return stripped;
						}
					}
				},
				customize: function (csv) {
					var total = 0;
					$('.prix-total').each(function() {
						total += parseFloat($(this).data('total')) || 0;
					});
					// Fixed: 7 columns total, so we need 5 semicolons before "Total:" and then the value
					csv += '\n;;;;;Total:;' + total.toFixed(2).replace('.', ',');
					return csv;
				}
			},
			{
				title:'Liste des Elements',
				extend: 'excel',
				exportOptions: {
					columns: [0, 2, 3, 4, 5, 6, 7],
					orthogonal: 'export',
					format: {
						body: function (data, row, column, node) {
							// Strip HTML tags from all columns first
							var stripped = $('<div>').html(data).text();
							
							// For Prix d'achat (column 6) and Prix Total (column 7)
							if (column === 6 || column === 7) {
								var value = $(node).data('prix') || $(node).data('total');
								if (value !== undefined) {
									return parseFloat(value);
								}
							}
							
							return stripped;
						}
					}
				},
				customize: function (xlsx) {
					var sheet = xlsx.xl.worksheets['sheet1.xml'];
					
					var total = 0;
					$('.prix-total').each(function() {
						total += parseFloat($(this).data('total')) || 0;
					});
					
					var lastRow = $('row', sheet).length;
					// Fixed: Column F for "Total:" (index 6) and Column G for the value (index 7)
					var totalRow = '<row r="' + (lastRow + 1) + '">' +
						'<c t="inlineStr" r="F' + (lastRow + 1) + '"><is><t>Total:</t></is></c>' +
						'<c t="n" r="G' + (lastRow + 1) + '"><v>' + total.toFixed(2) + '</v></c>' +
						'</row>';
					
					$('sheetData', sheet).append(totalRow);
				}
			},
            {
				title:'Liste des Elements',
                extend: 'pdf',
				text: 'PDF',
                orientation: 'landscape',
                pageSize: 'A4',
                exportOptions: {
                    columns: [0, 2, 3, 4, 5, 6, 7],
                    stripHtml: true,
                    format: {
                        body: function (data, row, column, node) {
                            // For Prix d'achat (column 6) and Prix Total (column 7)
                            if (column === 6 || column === 7) {
                                var value = $(node).data('prix') || $(node).data('total');
                                if (value !== undefined) {
                                    return parseFloat(value).toFixed(2).replace('.', ',') + ' €';
                                }
                            }
                            
                            // For other columns, just strip HTML
                            if (typeof data === 'string') {
                                return data.replace(/<[^>]*>/g, '').trim();
                            }
                            return data;
                        }
                    }
                },
				
                customize: function (doc) {
					// Set document properties
					doc.pageMargins = [20, 20, 20, 20];
					
					// Calculate total
					var total = 0;
					$('.prix-total').each(function() {
						total += parseFloat($(this).data('total')) || 0;
					});
					
					// Ensure the table body exists
					if (doc.content && doc.content[1] && doc.content[1].table && doc.content[1].table.body) {
						
						// Set alignment for ALL rows (header + body)
						doc.content[1].table.body.forEach(function(row, rowIndex) {
							row.forEach(function(cell, cellIndex) {
								// Convert string cells to objects so we can add properties
								if (typeof cell === 'string') {
									row[cellIndex] = {
										text: cell,
										alignment: 'left'
									};
								} else if (typeof cell === 'object' && cell.text !== undefined) {
									// If already an object, just add alignment
									cell.alignment = cell.alignment || 'left';
								}
								
								// Special alignment for numeric columns (Prix d'achat and Prix Total)
								if (cellIndex === 5 || cellIndex === 6) {
									if (typeof row[cellIndex] === 'string') {
										row[cellIndex] = {
											text: row[cellIndex],
											alignment: 'right'
										};
									} else if (typeof row[cellIndex] === 'object') {
										row[cellIndex].alignment = 'right';
									}
								}
							});
						});
						
						// Add total row - only 7 columns
						doc.content[1].table.body.push([
							{text: '', alignment: 'left'}, 
							{text: '', alignment: 'left'}, 
							{text: '', alignment: 'left'}, 
							{text: '', alignment: 'left'}, 
							{text: '', alignment: 'left'}, 
							{text: 'Total:', bold: true, alignment: 'right', fillColor: '#f8f9fa'}, 
							{text: total.toFixed(2).replace('.', ',') + ' €', bold: true, alignment: 'right', fillColor: '#f8f9fa'}
						]);
						
						// Style adjustments - 7 columns total
						doc.content[1].table.widths = ['8%', '20%', '15%', '12%', '12%', '15%', '18%'];
						
						// Make header row bold with blue background
						if (doc.content[1].table.body[0]) {
							doc.content[1].table.body[0].forEach(function(cell) {
								if (typeof cell === 'string') {
									// Convert to object first
									var cellText = cell;
									cell = {
										text: cellText,
										fillColor: '#007bff',
										color: 'white',
										bold: true,
										alignment: 'left'
									};
								} else if (typeof cell === 'object') {
									cell.fillColor = '#007bff';
									cell.color = 'white';
									cell.bold = true;
									// Keep existing alignment or set to left
									cell.alignment = cell.alignment || 'left';
								}
								return cell;
							});
							
							// Fix: need to reassign the modified row back
							doc.content[1].table.body[0] = doc.content[1].table.body[0].map(function(cell) {
								if (typeof cell === 'string') {
									return {
										text: cell,
										fillColor: '#007bff',
										color: 'white',
										bold: true,
										alignment: 'left'
									};
								}
								return cell;
							});
						}
					}
				}
            },
            {
				title: '<h2 style="text-align: center;">Liste des Elements</h2>',
				extend: 'print',
				exportOptions: {
					columns: [0, 2, 3, 4, 5, 6, 7],
                    orthogonal: 'export',
                    format: {
                        body: function (data, row, column, node) {
                            // Strip HTML tags
                            return $('<div>').html(data).text();
                        }
                    }
				},
				customize: function (doc) {
					// Set document properties
					doc.pageMargins = [20, 20, 20, 20];
					
					// Calculate total
					var total = 0;
					$('.prix-total').each(function() {
						total += parseFloat($(this).data('total')) || 0;
					});
					
					// Ensure the table body exists
					if (doc.content && doc.content[1] && doc.content[1].table && doc.content[1].table.body) {
						// Add total row - only 7 columns because we're exporting columns [0, 2, 3, 4, 5, 6, 7]
						doc.content[1].table.body.push([
							'', // Column 0
							'', // Column 2 (Element)
							'', // Column 3 (Famille)
							'', // Column 4 (Alerte Qte)
							'', // Column 5 (Qte)
							{text: 'Total:', style: 'tableHeader', bold: true, alignment: 'right'}, // Column 6 (Prix d'achat)
							{text: total.toFixed(2).replace('.', ',') + ' €', style: 'tableHeader', bold: true} // Column 7 (Prix Total)
						]);
						
						// Style adjustments - 7 columns total
						doc.content[1].table.widths = ['8%', '20%', '15%', '12%', '12%', '15%', '18%'];
						
						// Make header row bold with blue background
						if (doc.content[1].table.body[0]) {
							doc.content[1].table.body[0].forEach(function(cell) {
								cell.fillColor = '#007bff';
								cell.color = 'white';
								cell.bold = true;
							});
						}
						
						// Style the total row
						var lastRowIndex = doc.content[1].table.body.length - 1;
						doc.content[1].table.body[lastRowIndex].forEach(function(cell, index) {
							if (typeof cell === 'object') {
								cell.fillColor = '#f8f9fa';
							}
						});
					}
				}
			},
            'colvis'
        ]
    });
</script>

@endsection