@extends('admin.layout')
@section('title') Demandes de Matériels @endsection
@section('content')

<div class="intro-y mb-3 flex items-center">
    <div class="row">
        <div class="col-8 mb-4 mb-xl-0">
            <h2 class="mr-auto text-lg font-medium">Demandes de Matériels</h2>
        </div>
        <div class="col-4">
            <div class="justify-content-end d-flex">
                <a href="{{ route('admin.materiels') }}" class="btn btn-primary mr-2">
                    <i class="fa fa-arrow-left"></i> Retour aux Matériels
                </a>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-12 grid-margin stretch-card">
        <div class="card">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped table-borderless datatables" id="table1">
                        <thead>
                            <tr>
                                <th></th>
                                <th>Photo</th>
                                <th>Employé</th>
                                <th>Matériel</th>
                                <th>Référence</th>
                                <th>Date Nécessaire</th>
                                <th>Raison</th>
                                <th>Date Demande</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $i=1; ?>
                            @foreach($requests as $request)
                            <tr>
                                <td>{{ $i++ }}</td>
                                <td>
                                    @if($request->materiel->photo)
                                        @php $photos = json_decode($request->materiel->photo); @endphp
                                        @if(!empty($photos))
                                            <img src="{{ asset('uploads/' . $photos[0]) }}" alt="Photo" class="rounded" height="50" width="50"/>
                                        @else
                                            <img src="{{ asset('assets/images/no_image.png') }}" alt="No Image" class="rounded" height="50" width="50"/>
                                        @endif
                                    @else
                                        <img src="{{ asset('assets/images/no_image.png') }}" alt="No Image" class="rounded" height="50" width="50"/>
                                    @endif
                                </td>
                                <td>{{ $request->employee->prenom }} {{ $request->employee->name }}</td>
                                <td>{{ $request->materiel->materiel }}</td>
                                <td>{{ $request->materiel->reference ?? 'Aucun' }}</td>
                                <td>
                                    @if($request->date_needed)
                                        {{ \Carbon\Carbon::parse($request->date_needed)->format('d/m/Y') }}
                                    @else
                                        <span class="text-muted">Non spécifié</span>
                                    @endif
                                </td>
                                <td>{{ $request->reason ?? '-' }}</td>
                                <td>{{ $request->created_at->format('d/m/Y H:i') }}</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Reject Modal -->
<div class="modal fade" id="rejectModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="{{ route('admin.reject-materiel-request') }}" method="POST">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title">Rejeter la Demande</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="request_id" id="reject_request_id">
                    <div class="mb-3">
                        <label>Notes Admin (Optionnel):</label>
                        <textarea name="admin_notes" class="form-control" rows="3"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Annuler</button>
                    <button type="submit" class="btn btn-danger">Rejeter</button>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection

@section('script')
<script>
$('.approve-btn').click(function(e){
    e.preventDefault();
    var url = $(this).attr('href');
    
    Swal.fire({
        title: "Approuver la demande?",
        text: "Cette action affectera le matériel à l'employé et le marquera comme indisponible.",
        icon: "question",
        showCancelButton: true,
        confirmButtonText: "Oui, approuver",
        cancelButtonText: "Annuler"
    }).then((result) => {
        if (result.isConfirmed) {
            window.location.href = url;
        }
    });
});

$('.reject-btn').click(function(){
    var requestId = $(this).data('id');
    $('#reject_request_id').val(requestId);
    $('#rejectModal').modal('show');
});

$('#table1').DataTable();
</script>
@endsection