@extends('admin.layout')
@section('title') Notifications @endsection
@section('content')


<div class="page-title">
    <div class="row mb-3">
        <div class="col-12 col-md-6 order-md-1 order-last">
            <h3>Notifications</h3>
        </div>
        <div class="col-12 col-md-6 order-md-2 order-first">
            <nav aria-label="breadcrumb" class="breadcrumb-header float-start float-lg-end">
                <!-- <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="./">Dashboard</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Notifications</li>
                </ol> -->
                <a href="{{ route('admin.add-notification') }}" class='btn btn-primary btn-block btn-xl '>
                    <i class="fa-solid fa-bell"></i> Add Notification
                </a>
            </nav>
        </div>
    </div>
</div>




<div class="row">
	
	<div class="">
		<div class="card shadow">
	        <div class="card-body">
	          <!-- table -->
              @if($notifications->isEmpty())
                    <p>No notifications found.</p>
                @else
	          <table class="table datatables" id="table1" align="center">
	            <thead>
	              <tr>
                  <th>Title</th>
                    <th>Type</th>
                    <th>End Date</th>
                    <th>Content</th>
                    <th>Employees</th>
                    <th>Actions</th>
	              </tr>
	            </thead>
	            <tbody>
	            	
                    @foreach($notifications as $notification)
                    <tr>
                        <td>{{ $notification->title }}</td>
                        <td><div class="badge bg-{{ $notification->type }}">
                            {{ ucfirst($notification->type) }}
                        </div>
                        </td>
                        <td>{{ $notification->end_date ? $notification->end_date : 'N/A' }}</td>
                        <td>
                            @if($notification->content)
                            <p>{{ $notification->content }}</p>
                        @endif
                        @if($notification->image)
                            <img src="{{ asset('public/layout/assets/notifications/' . $notification->image) }}" alt="Notification Image" class="rounded" height="100" width="auto">
                        @endif
                        </td>
                        <td>
                            @if($notification->for_all_employees)
                                <p class="badge bg-light-primary">All Employees</p>
                            @else
                                @if($notification->employees->isEmpty())
                                    No Employees
                                @else
                                    @foreach($notification->employees as $employee)
                                        <p class="badge bg-primary">{{ $employee->name }}</p>
                                    @endforeach
                                @endif
                            @endif
                        </td>
                        <td>
                            
							<a data-id="{{ $notification->id }}" class="btn btn-danger rounded me-1 delete" href="javascript::void();"><i class="fa-solid fa-trash"></i></a>
                            
                        </td>
                    </tr>
                    @endforeach
	            </tbody>
	          </table>
              @endif

                
	        </div>
	    </div>
	</div>
</div>
@endsection
@section('script')

    <script>
        // Simple Datatable
        let table1 = document.querySelector('#table1');
        let dataTable = new simpleDatatables.DataTable(table1);
    </script>

<script type="text/javascript">
	$('.delete').click(function(){
		var dataId = $(this).attr("data-id");
		Swal.fire({
		  title: "Are you sure?",
		  text: "Once you confirm, this action cannot be undone!",
		  icon: "warning",
		  showCancelButton: true,
		  confirmButtonColor: "#3085d6",
		  cancelButtonColor: "#d33",
		  confirmButtonText: "Yes, delete!"
		}).then((result) => {
		  if (result.isConfirmed) {
		    window.open(`{{ route("admin.delete-notification", [":dataId"]) }}`.replace(':dataId', dataId),"_self");
		  }
		});
	});
</script>
@endsection