@extends('admin.layout')
@section('title') Paramètres @endsection
@section('content')

<div class="row">
    <div class="col-lg-12 grid-margin stretch-card">
        <div class="card">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h4 class="card-title">Gestion des Jours Fériés</h4>
                    <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#addHolidayModal">
                        <i class="fa fa-plus"></i> Ajouter un Jour Férié
                    </button>
                </div>

                <div class="table-responsive">
                    <table class="table table-striped table-borderless datatables" id="holidaysTable">
                        <thead>
                            <tr>
                                <th>Nom</th>
                                <th>Date de début</th>
                                <th>Date de fin</th>
                                <th>Type</th>
                                <th>Région</th>
                                <th>Statut</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($holidays as $holiday)
                            <tr>
                                <td>{{ $holiday->name }}</td>
                                <td>{{ $holiday->date_debut->format('d/m/Y') }}</td>
                                <td>{{ $holiday->date_fin->format('d/m/Y') }}</td>
                                <td>
                                    @if($holiday->type === 'national')
                                        <span class="badge badge-primary">National</span>
                                    @elseif($holiday->type === 'regional')
                                        <span class="badge badge-info">Régional</span>
                                    @else
                                        <span class="badge badge-secondary">Personnalisé</span>
                                    @endif
                                </td>
                                <td>{{ $holiday->region ?? 'France' }}</td>
                                <td>
                                    <form method="POST" action="{{ route('admin.toggle-holiday', $holiday->id) }}" style="display: inline;">
                                        @csrf
                                        <button type="submit" class="btn btn-sm {{ $holiday->is_active ? 'btn-success' : 'btn-secondary' }}">
                                            {{ $holiday->is_active ? 'Actif' : 'Inactif' }}
                                        </button>
                                    </form>
                                </td>
                                <td>
                                    <button class="btn btn-sm btn-info edit-holiday" data-id="{{ $holiday->id }}" 
                                            data-name="{{ $holiday->name }}" data-start="{{ $holiday->date_debut->format('Y-m-d') }}" 
                                            data-end="{{ $holiday->date_fin->format('Y-m-d') }}" data-type="{{ $holiday->type }}" 
                                            data-region="{{ $holiday->region }}">
                                        <i class="fas fa-edit"></i>
                                    </button>
                                    <button class="btn btn-sm btn-danger delete-holiday" data-id="{{ $holiday->id }}">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add Holiday Modal -->
<div class="modal fade" id="addHolidayModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Ajouter un Jour Férié</h5>
                <button type="button" class="close" data-dismiss="modal">
                    <span>&times;</span>
                </button>
            </div>
            <form method="POST" action="{{ route('admin.store-holiday') }}">
                @csrf
                <div class="modal-body">
                    <div class="form-group">
                        <label for="name">Nom du jour férié</label>
                        <input type="text" class="form-control" name="name" required>
                    </div>

                    <div class="form-group">
                        <label for="date_debut">Date de début</label>
                        <input type="date" class="form-control" name="date_debut" id="add_date_debut" required>
                    </div>

                    <div class="form-group">
                        <label for="date_fin">Date de fin</label>
                        <input type="date" class="form-control" name="date_fin" id="add_date_fin" required>
                    </div>

                    <div class="form-group">
                        <label for="type">Type</label>
                        <select class="form-control" name="type" required>
                            <option value="national">National</option>
                            <option value="regional">Régional</option>
                            <option value="custom">Personnalisé</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="region">Région (optionnel)</label>
                        <input type="text" class="form-control" name="region" placeholder="Ex: Alsace-Moselle">
                    </div>

                    <div class="form-group">
                        <label for="description">Description (optionnel)</label>
                        <textarea class="form-control" name="description" rows="2"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Fermer</button>
                    <button type="submit" class="btn btn-primary">Enregistrer</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Holiday Modal -->
<div class="modal fade" id="editHolidayModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Modifier le Jour Férié</h5>
                <button type="button" class="close" data-dismiss="modal">
                    <span>&times;</span>
                </button>
            </div>
            <form method="POST" id="editHolidayForm">
                @csrf
                @method('PUT')
                <div class="modal-body">
                    <div class="form-group">
                        <label for="edit_name">Nom du jour férié</label>
                        <input type="text" class="form-control" name="name" id="edit_name" required>
                    </div>

                    <div class="form-group">
                        <label for="edit_date_debut">Date de début</label>
                        <input type="date" class="form-control" name="date_debut" id="edit_date_debut" required>
                    </div>

                    <div class="form-group">
                        <label for="edit_date_fin">Date de fin</label>
                        <input type="date" class="form-control" name="date_fin" id="edit_date_fin" required>
                    </div>

                    <div class="form-group">
                        <label for="edit_type">Type</label>
                        <select class="form-control" name="type" id="edit_type" required>
                            <option value="national">National</option>
                            <option value="regional">Régional</option>
                            <option value="custom">Personnalisé</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="edit_region">Région (optionnel)</label>
                        <input type="text" class="form-control" name="region" id="edit_region">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Fermer</button>
                    <button type="submit" class="btn btn-primary">Mettre à jour</button>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection

@section('script')
<script>
$(document).ready(function() {
    // Date validation for add modal
    $('#add_date_debut').on('change', function() {
        const startDate = this.value;
        const endDateInput = $('#add_date_fin');
        
        endDateInput.attr('min', startDate);
        
        if (endDateInput.val() && endDateInput.val() < startDate) {
            endDateInput.val(startDate);
        }
    });
    
    $('#add_date_fin').on('change', function() {
        const endDate = this.value;
        const startDate = $('#add_date_debut').val();
        
        if (startDate && endDate < startDate) {
            this.setCustomValidity('La date de fin doit être après la date de début');
            this.reportValidity();
            return false;
        } else {
            this.setCustomValidity('');
        }
    });

    // Date validation for edit modal
    $('#edit_date_debut').on('change', function() {
        const startDate = this.value;
        const endDateInput = $('#edit_date_fin');
        
        endDateInput.attr('min', startDate);
        
        if (endDateInput.val() && endDateInput.val() < startDate) {
            endDateInput.val(startDate);
        }
    });
    
    $('#edit_date_fin').on('change', function() {
        const endDate = this.value;
        const startDate = $('#edit_date_debut').val();
        
        if (startDate && endDate < startDate) {
            this.setCustomValidity('La date de fin doit être après la date de début');
            this.reportValidity();
            return false;
        } else {
            this.setCustomValidity('');
        }
    });

    // Edit holiday
    $('.edit-holiday').click(function() {
        const id = $(this).data('id');
        const name = $(this).data('name');
        const startDate = $(this).data('start');
        const endDate = $(this).data('end');
        const type = $(this).data('type');
        const region = $(this).data('region');
        
        $('#editHolidayForm').attr('action', '/admin/update-holiday/' + id);
        $('#edit_name').val(name);
        $('#edit_date_debut').val(startDate);
        $('#edit_date_fin').val(endDate);
        $('#edit_type').val(type);
        $('#edit_region').val(region);
        $('#edit_date_fin').attr('min', startDate);
        
        $('#editHolidayModal').modal('show');
    });

    // Delete holiday
    $('.delete-holiday').click(function() {
        const id = $(this).data('id');
        
        Swal.fire({
            title: "Êtes-vous sûr?",
            text: "Cette action ne peut pas être annulée!",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "Oui, supprimer!",
            cancelButtonText: "Annuler"
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: '/admin/delete-holiday/' + id,
                    type: 'DELETE',
                    data: {
                        _token: '{{ csrf_token() }}'
                    },
                    success: function() {
                        location.reload();
                    }
                });
            }
        });
    });
});

// DataTable
$('#holidaysTable').DataTable({
    dom: 'Bfrtip',
    language: {
        url: '{{ asset("assets/fr-FR.json") }}'
    },
    buttons: [
        {
            title: 'Liste des Jours Fériés',
            extend: 'copy',
            exportOptions: {
                columns: [0, 1, 2, 3, 4, 5]
            }
        },
        {
            title: 'Liste des Jours Fériés',
            extend: 'excel',
            exportOptions: {
                columns: [0, 1, 2, 3, 4, 5]
            }
        },
        {
            title: 'Liste des Jours Fériés',
            extend: 'pdf',
            exportOptions: {
                columns: [0, 1, 2, 3, 4, 5]
            }
        },
        'colvis'
    ]
});
</script>
@endsection