@extends('manager.layout')
@section('title') Dashbaord @endsection
@section('content')
<div class="row">
	<div class="col-md-12">
		<div class="float-right">
			<div class="form-group">
                <label for="reportrange">Select Date Range</label>
                <div id="reportrange" class="border px-2 py-2 bg-light">
            		<i class="fe fe-calendar fe-16 mx-2"></i>
            		<span></span>
               	</div>
            </div>
		</div>
	</div>
</div>
<div class="row">
	<div class="col-md-12">
		<div class="card shadow mb-4">
	    	<div class="card-body">
	          <div class="card-title">
	            <strong>Order Report</strong>
	            <a class="float-right small text-muted" href="{{ route('manager.order-report') }}">View all</a>
	          </div>
	          <div class="row">
	            <div class="col-md-12">
	              <div id="chart-box">
	                <canvas id="myChart"  height="150"></canvas>
	              </div>
	            </div>
	          </div> <!-- .row -->
	    	</div> <!-- .card-body -->
	    </div>
	</div>
</div>
@endsection
@section('script')
<script type="text/javascript">
	function performAjaxRequest(startDate, endDate) {
		var title= "Order Report From "+startDate+" to "+endDate;
	  $.ajax({
            url:'{{ route("manager.chart-orders") }}',
            type: 'post',
            data:{
                '_token':'{{ csrf_token() }}',
                'start_date':startDate,
                'end_date':endDate,
                'employee':"{{ $employee->id }}",
            },
            success:function(responsedata){
                var xValues = ["Pending", "Confirmed", "Picked Up", "Returned", "Delivered"];
				var yValues = responsedata;
				var barColors = [
				  "#00aba9",
				  "#e8c3b9",
				  "#2b5797",
				  "#b91d47",
				  "#1e7145"
				];

				new Chart("myChart", {
				  type: "doughnut",
				  data: {
				    labels: xValues,
				    datasets: [{
				      backgroundColor: barColors,
				      data: yValues
				    }]
				  },
				  options: {
				    title: {
				      display: true,
				      text: title,
				    },
				    tooltips: {
				      callbacks: {
				        label: function (tooltipItem, data) {
				          var dataset = data.datasets[tooltipItem.datasetIndex];
				          var total = dataset.data.reduce(function (previousValue, currentValue) {
				            return previousValue + currentValue;
				          });
				          var currentValue = dataset.data[tooltipItem.index];
				          var percentage = ((currentValue / total) * 100).toFixed(2) + "%";
				          return xValues[tooltipItem.index] + ": " + currentValue + " (" + percentage + ")";
				        }
				      }
				    }
				  }
				});
            },
            error: function(data) {
                var errors = data.responseJSON.errors;
                for(var key in errors){
                    toastr.error(errors[key][0]);
                }
            },
        });
	}
	performAjaxRequest("<?= date('d/m/Y'); ?>","<?= date('d/m/Y'); ?>");
	var start = moment();
    var end = moment();
	function cb(start, end)
      {
        $('#reportrange span').html(start.format('DD/MM/YYYY') + ' - ' + end.format('DD/MM/YYYY'));
      }
      $('#reportrange').daterangepicker(
      {
        startDate: start,
        endDate: end,
        ranges:
        {
          'Today': [moment(), moment()],
          'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
          'Last 7 Days': [moment().subtract(6, 'days'), moment()],
          'Last 30 Days': [moment().subtract(29, 'days'), moment()],
          'This Month': [moment().startOf('month'), moment().endOf('month')],
          'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
        }
      }, cb);
      $('#reportrange').on('apply.daterangepicker', function(ev, picker) {
		performAjaxRequest(picker.startDate.format('DD/MM/YYYY'),picker.endDate.format('DD/MM/YYYY'));
	});
</script>
@endsection