<!doctype html>
<?php $user = \App\Models\User::find(session('current_manager')->id); ?>
<html lang="en">
  <head> 
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">
    <link rel="icon" href="favicon.ico">
    <title> @yield('title') | {{ config('app.name') }}</title>
    <!-- Simple bar CSS -->
    <link rel="stylesheet" href="{{ asset('layout/css/simplebar.css') }}">
    <!-- Fonts CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Overpass:ital,wght@0,100;0,200;0,300;0,400;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">
    <!-- Icons CSS -->
    <link rel="stylesheet" href="{{ asset('layout/css/feather.css') }}">
    <link rel="stylesheet" href="{{ asset('layout/css/select2.css') }}">
    <link rel="stylesheet" href="{{ asset('layout/css/dropzone.css') }}">
    <link rel="stylesheet" href="{{ asset('layout/css/uppy.min.css') }}">
    <link rel="stylesheet" href="{{ asset('layout/css/jquery.steps.css') }}">
    <link rel="stylesheet" href="{{ asset('layout/css/jquery.timepicker.css') }}">
    <link rel="stylesheet" href="{{ asset('layout/css/quill.snow.css') }}">
    <link rel="stylesheet" href="{{ asset('layout/css/custom.css') }}">
    <!-- Date Range Picker CSS -->
    <link rel="stylesheet" href="{{ asset('layout/css/daterangepicker.css') }}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/js/all.min.js" integrity="sha512-GWzVrcGlo0TxTRvz9ttioyYJ+Wwk9Ck0G81D+eO63BaqHaJ3YZX9wuqjwgfcV/MrB2PhaVX9DkYVhbFpStnqpQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <!-- App CSS -->
    <link rel="stylesheet" href="{{ asset('layout/css/app-light.css') }}" id="lightTheme">
    <link rel="stylesheet" href="{{ asset('layout/css/app-dark.css') }}" id="darkTheme" disabled>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11.10.2/dist/sweetalert2.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" integrity="sha512-vKMx8UnXk60zUwyUnUPM3HbQo8QfmNx7+ltw8Pm5zLusl1XIfwcxo8DbWCqMGKaWeNxWA8yrx5v3SaVpMvR3CA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="{{ asset('layout/js/jquery.min.js') }}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js" integrity="sha512-VEd+nq25CkR676O+pLBnDW09R7VQX9Mdiij052gVCp5yVH3jGtH70Ho/UUv4mJDsEdTvqRCFZg0NKGiojGnUCw==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.10.2/dist/sweetalert2.all.min.js"></script>
    <script src="https://cdn.tiny.cloud/1/q8c6rroyhhanf0vjq991tc8yjkfw8n7unny0eu6lvnpesxi5/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>
    <script>
      tinymce.init({
        selector: 'textarea#editor',
        plugins: 'ai tinycomments mentions anchor autolink charmap codesample emoticons image link lists media searchreplace table visualblocks wordcount checklist mediaembed casechange export formatpainter pageembed permanentpen footnotes advtemplate advtable advcode editimage tableofcontents mergetags powerpaste tinymcespellchecker autocorrect a11ychecker typography inlinecss',
        toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikethrough | link image media table mergetags | align lineheight | tinycomments | checklist numlist bullist indent outdent | emoticons charmap | removeformat',
        tinycomments_mode: 'embedded',
        tinycomments_author: 'Author name',
        mergetags_list: [
          { value: 'First.Name', title: 'First Name' },
          { value: 'Email', title: 'Email' },
        ],
        ai_request: (request, respondWith) => respondWith.string(() => Promise.reject("See docs to implement AI Assistant")),
      });
    </script>
    <style type="text/css">
      div.dataTables_wrapper {
        width: 100%;
        margin: 0 auto;
      }

      div.dt-buttons {
        float: center;
      }

      div.dataTables_filter {
        float: right;
      }

      div.dataTables_length {
        float: left;
      }
    </style>
  </head>
  <body class="vertical  light  ">
    @if (session()->has('error'))
      <script type="text/javascript">toastr.error('{{ session("error") }}');</script>
    @endif
    @if (session()->has('success'))
      <script type="text/javascript">toastr.success('{{ session("success") }}');</script>
    @endif
    @if ($errors->any())
      @foreach ($errors->all() as $error)
        <script type="text/javascript">toastr.error('{{ $error }}');</script>
      @endforeach
    @endif
    <div class="wrapper">
      <nav class="topnav navbar navbar-light">
        <button type="button" class="navbar-toggler text-muted mt-2 p-0 mr-3 collapseSidebar">
          <i class="fe fe-menu navbar-toggler-icon"></i>
        </button>
        <ul class="nav">
          <li class="nav-item">
            <a class="nav-link text-muted my-2" href="{{ route('manager.import-orders') }}"><span class="fe fe-16 fe-refresh-cw"></span></a>
          </li>
          <li class="nav-item">
            <a class="nav-link text-muted my-2" href="#" id="modeSwitcher" data-mode="light">
              <i class="fe fe-sun fe-16"></i>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link text-muted my-2" href="{{ route('manager.messages') }}"><i class="fa-solid fa-envelope"></i></a>
          </li>
          <li class="nav-item dropdown">
            <a class="nav-link dropdown-toggle text-muted pr-0" href="#" id="navbarDropdownMenuLink" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
              <span class="avatar avatar-sm mt-2">
                <img src="<?php echo (isset($user->image)) ? asset('layout/assets/avatars/'.'/'.$user->image) : asset('layout/assets/avatars/user.jpg') ; ?>" alt="..." class="avatar-img rounded-circle">
              </span>
            </a>
            <div class="dropdown-menu dropdown-menu-right" aria-labelledby="navbarDropdownMenuLink">
              <a class="dropdown-item" href="{{ route('manager.edit-profile') }}"><i class="fa fa-pencil"></i> Edit Profile</a>
              <a class="dropdown-item" href="{{ route('manager.logout') }}"><i class="fa fa-power-off"></i> Logout</a>
            </div>
          </li>
        </ul>
      </nav>
      <aside class="sidebar-left border-right bg-white shadow" id="leftSidebar" data-simplebar>
        <a href="#" class="btn collapseSidebar toggle-btn d-lg-none text-muted ml-2 mt-3" data-toggle="toggle">
          <i class="fe fe-x"><span class="sr-only"></span></i>
        </a>
        <nav class="vertnav navbar navbar-light">
          <!-- nav bar -->
          <div class="w-100 mb-4 d-flex">
            <a class="navbar-brand mx-auto mt-2 flex-fill text-center" href="./index.html">
                <img src="https://i.ibb.co/dkSvR6V/Logo.png" width="100">
            </a>
          </div>
          <ul class="navbar-nav flex-fill w-100 mb-2">
            <li class="nav-item w-100 {{ Request::routeIs('manager.dashboard') ? 'active' : '' }}">
              <a class="nav-link" href="{{ route('manager.dashboard') }}">
                <i class="fe fe-home fe-16"></i>
                <span class="ml-3 item-text">Dashbaord</span>
              </a>
            </li>
            <li class="nav-item w-100 {{ Request::routeIs(['manager.manage-employees','manager.edit-employee','manager.employee-orders','manager.employee-report']) ? 'active' : '' }}">
              <a class="nav-link" href="{{ route('manager.manage-employees') }}">
                <i class="fa-solid fa-users-rays"></i>
                <span class="ml-3 item-text">Manage Employees</span>
              </a>
            </li>
          </ul>
        </nav>
      </aside>
      <main role="main" class="main-content">
        <div class="container-fluid">
          @yield('content')
          </div> <!-- .row -->
        </div> <!-- .container-fluid -->
      </main> <!-- main -->
    </div> <!-- .wrapper -->
    <script src="{{ asset('layout/js/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('layout/js/dataTables.bootstrap4.min.js') }}"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.print.min.js"></script>
    <script src="{{ asset('layout/js/popper.min.js') }}"></script>
    <script src="{{ asset('layout/js/moment.min.js') }}"></script>
    <script src="{{ asset('layout/js/bootstrap.min.js') }}"></script>
    <script src="{{ asset('layout/js/simplebar.min.js') }}"></script>
    <script src="{{ asset('layout/js/daterangepicker.js') }}"></script>
    <script src="{{ asset('layout/js/jquery.stickOnScroll.js') }}"></script>
    <script src="{{ asset('layout/js/tinycolor-min.js ') }}"></script>
    <script src="{{ asset('layout/js/config.js') }}"></script>
    <script src="{{ asset('layout/js/d3.min.js') }}"></script>
    <script src="{{ asset('layout/js/topojson.min.js') }}"></script>
    <script src="{{ asset('layout/js/datamaps.all.min.js') }}"></script>
    <script src="{{ asset('layout/js/datamaps-zoomto.js') }}"></script>
    <script src="{{ asset('layout/js/datamaps.custom.js') }}"></script>
    <script src="{{ asset('layout/js/Chart.min.js') }}"></script>
    <script>
      /* defind global options */
      Chart.defaults.global.defaultFontFamily = base.defaultFontFamily;
      Chart.defaults.global.defaultFontColor = colors.mutedColor;
    </script>
    <script src="{{ asset('layout/js/gauge.min.js') }}"></script>
    <script src="{{ asset('layout/js/jquery.sparkline.min.js') }}"></script>
    <script src="{{ asset('layout/js/apexcharts.min.js') }}"></script>
    <script src="{{ asset('layout/js/apexcharts.custom.js') }}"></script>
    <script src="{{ asset('layout/js/jquery.mask.min.js') }}"></script>
    <script src="{{ asset('layout/js/select2.min.js') }}"></script>
    <script src="{{ asset('layout/js/jquery.steps.min.js') }}"></script>
    <script src="{{ asset('layout/js/jquery.validate.min.js') }}"></script>
    <script src="{{ asset('layout/js/jquery.timepicker.js') }}"></script>
    <script src="{{ asset('layout/js/dropzone.min.js') }}"></script>
    <script src="{{ asset('layout/js/uppy.min.js') }}"></script>
    <script src="{{ asset('layout/js/quill.min.js') }}"></script>
    <script src="{{ asset('layout/js/apps.js') }}"></script>
    <script>
        setInterval(function(){
          $.ajax({
            'url': '{{ route("update-status",session('current_manager')->id) }}',
            'method': 'GET',
            success:function(responsedata){

            }
          });
        },3000);
      </script>
    @yield('script')
  </body>
</html>