@extends('manager.layout')
@section('title') Manage Employees @endsection
@section('content')

<div class="row">
	<div class="col-md-12">
		<div class="card p-2">
			<center>
				<span class="text-primary" style="font-size:25px;"><i class="fa-solid fa-users-rays"></i>&nbsp;&nbsp;Manage Employees</span>
			</center>
		</div>
	</div>
</div>
<br><br>
<div class="row">
	<div class="col-md-12">
		<div class="card shadow">
	        <div class="card-body">
	          <!-- table -->
	          <table class="table datatables" id="dataTable">
	            <thead>
	              <tr>
	                <th>#</th>
	                <th>Name</th>
	                <th>Phone</th>
	                <th>Email</th>
	                <th>Action</th>
	              </tr>
	            </thead>
	            <tbody>
	            	<?php $i= 1; ?>
	              @foreach($employees as $employee)
	              <tr>
	                <td>{{ $i++ }}</td>
	                <td>{{ $employee->name }}</td>
	                <td>{{ $employee->phone }}</td>
	                <td>{{ $employee->email }}</td>
	                <td><button class="btn btn-sm dropdown-toggle more-horizontal" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
	                    <span class="text-muted sr-only">Action</span>
	                  </button>
	                  <div class="dropdown-menu dropdown-menu-right">
	                    <a class="dropdown-item" href='{{ route("manager.edit-employee",$employee->id) }}'>Edit</a>
	                    <a class="dropdown-item" href='{{ route("manager.employee-orders",$employee->id) }}'>Employee Orders</a>
	                    <a class="dropdown-item" href='{{ route("manager.employee-report",$employee->id) }}'>Employee Report</a>
	                    <a class="dropdown-item" href='{{ route("manager.add-message",$employee->id) }}'>Message Employee</a>
	                  </div>
	                </td>
	              </tr>
	              @endforeach
	            </tbody>
	          </table>
	        </div>
	    </div>
	</div>
</div>
@endsection
@section('script')
<script>
  $(document).ready(function () {
    $('#dataTable').DataTable({
      dom: 'lBfrtip',
      autoWidth: true,
      buttons: [
        { extend: 'copy', className: 'btn btn-sm btn-primary' },
        { extend: 'excel', className: 'btn btn-sm btn-primary' },
        { extend: 'csv', className: 'btn btn-sm btn-primary' },
        { extend: 'pdf', className: 'btn btn-sm btn-primary' },
        { extend: 'print', className: 'btn btn-sm btn-primary' }
      ],
      lengthMenu: [
        [16, 32, 64, -1],
        [16, 32, 64, "All"]
      ],
    });
  });
</script>
@endsection