@extends('manager.layout')
@section('title') Orders Report @endsection
@section('content')
<div class="row">
	<div class="col-md-12">
		<div class="card p-2">
			<center>
				<span class="text-primary" style="font-size:25px;"><i class="fe fe-box"></i>&nbsp;&nbsp;Orders Report</span>
			</center>
		</div>
	</div>
</div>
<br>
<div class="row">
	<div class="col-md-12">
		<div class="card p-2">
			<form method="POST" action="{{ route('manager.search-order-report') }}">
				@csrf
				<div class="row">
					<div class="col-md-6">
						<div class="form-group mb-3">
	            <label for="source">Employee:</label>
              <select class="form-control select2" name="employee" style="width:100%;" data-placeholder="Employee" id="employee" required>
              	<option value=" " <?= ($employee1 == " ")?'selected':''; ?> > Select Employee</option>
              	<option value="0" <?= ($employee1 == "0")?'selected':''; ?> > Without Employees</option>
              	@foreach($employees as $employee)
                <option value="{{ $employee->id }}" <?= ($employee1 == $employee->id)?'selected':''; ?> >{{ $employee->name }}</option>
                @endforeach
              </select>
			      </div>
					</div>
					<div class="col-md-6">
						<div class="form-group mb-3">
	            <label for="date-input1">Date:</label>
	            <div class="input-group">
	            	<input type="text" name="date" class="form-control datetimes" id="date-input1" value="Select a Date" aria-describedby="button-addon2">
	            	<div class="input-group-append">
	              	<div class="input-group-text" id="button-addon-date"><span class="fa-solid fa-eraser"></span></div>
	              </div>
	            </div>
					  </div>
					</div>
				</div>
				<div class="row">
					<div class="col-md-6">
						<div class="form-group mb-3">
	            <label for="status">Status:</label>
              <select class="form-control select2" name="status" style="width:100%;" data-placeholder="Status" id="status" required>
              	<option value=" "> Select Status</option>
              		<option <?= ($status1 == "Pending")?'selected':''; ?> >Pending</option>
	                <option <?= ($status1 == "Confirmed")?'selected':''; ?> >Confirmed</option>
	                <option <?= ($status1 == "Picked Up")?'selected':''; ?> >Picked Up</option>
	                <option <?= ($status1 == "Returned")?'selected':''; ?> >Returned</option>
	                <option <?= ($status1 == "Delivered")?'selected':''; ?> >Delivered</option>
              </select>
			      </div>
					</div>
					<div class="col-md-6">
						<label>&nbsp;</label>
						<button type="submit" class="btn btn-block btn-primary"><i class="fa-solid fa-filter"></i> Filter Orders</button>
					</div>
				</div>
			</form>
		</div>
	</div>
</div>
<br><br>
<div class="row">
	<div class="col-md-12">
		<div class="card p-2">
			<table class="table table-responsive datatables" id="dataTable">
	      <thead>
	        <tr>
	          <th>#</th>
	          <th>Date</th>
	          <th>Customer Name</th>
	          <th>Phone</th>
	          <th>Address</th>
	          <th>City</th>
	          <th>Product</th>
	          <th>Product Variant</th>
	          <th>Source</th>
	          <th>Price</th>
	          <th>Employee</th>
	          <th>Status</th>
	        </tr>
	      </thead>
	      <tbody>
	      	<?php $i= 1; ?>
	        @foreach($orders as $order)
	        <?php
	        $employee_name = null;
	        $employee_email = null;
	        if($order->employee_id != 0){
	        	$employee1 = \App\Models\User::find($order->employee_id);
	        	$employee_name = $employee1->name;
	        	$employee_email = $employee1->email;
	        }else{
	        	$employee_name = "No Employee";
	        	$employee_email = "<center>--</center>";
	        }
	         ?>
	        <tr>
	          <td>{{ $i++ }}</td>
	          <td>{{ $order->date }}</td>
	          <td>{{ $order->full_name }}</td>
	          <td>{{ $order->phone }}</td>
	          <td>{{ $order->address }}</td>
	          <td>{{ $order->city }}</td>
	          <td>{{ $order->product_name }}</td>
	          <td>{!! $order->product_variant !!}</td>
	          <td>{{ $order->source}}</td>
	          <td>{{ $order->price}}</td>
	          <td>{{ $employee_name }}</td>
	          <td>{{ $order->status}}</td>
	        </tr>
	        @endforeach
	      </tbody>
	    </table>
		</div>
	</div>
</div>
@endsection
@section('script')

<script>
	$('.select2').select2(
      {
        theme: 'bootstrap4',
      });
	$('.drgpicker').daterangepicker({
        singleDatePicker: true,
        timePicker: false,
        showDropdowns: true,
        locale:
        {
          format: 'DD/MM/YYYY'
        }
    });
	$('.datetimes').daterangepicker({
    timePicker:false,
  });
  $('#dataTable').DataTable({
      dom: 'lBfrtip',
      autoWidth: true,
      buttons: [
        { extend: 'copy', className: 'btn btn-sm btn-primary' },
        { extend: 'excel', className: 'btn btn-sm btn-primary' },
        { extend: 'csv', className: 'btn btn-sm btn-primary' },
        { extend: 'pdf', className: 'btn btn-sm btn-primary' },
        { extend: 'print', className: 'btn btn-sm btn-primary' }
      ],
      lengthMenu: [
        [16, 32, 64, -1],
        [16, 32, 64, "All"]
      ],
    });
  var date1 = "<?= $date1; ?>";
  if(date1 == "Select a Date"){
  	$('#date-input1').val('Select a Date');
  }
  $('#button-addon-date').click(()=>{
  	$('#date-input1').val('Select a Date');
  });
</script>
@endsection