<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\UserController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\EmployeeController;
use App\Http\Controllers\ManagerController;
use App\Http\Controllers\CouvreurController;
use Maatwebsite\Excel\Facades\Excel;
use App\Exports\OrdersExport;


/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/



Route::get('/', [UserController::class,'index'] )->name('index');
Route::get('/admin',[UserController::class,'login'])->name('admin.login');
Route::get('/admin/login',[UserController::class,'login'])->name('admin.login');
Route::post('/admin/login',[UserController::class,'checkLogin'])->name('admin.check-login');


Route::get('/login',[UserController::class,'elogin'])->name('employee.login');
Route::post('/login',[UserController::class,'echeckLogin'])->name('check-login');



Route::get('/register',[UserController::class,'register'])->name('register');

Route::post('/get-message',[UserController::class,'getMessages' ])->name('get-messages');
Route::post('/get-chats',[UserController::class,'getChats' ])->name('get-chats');
Route::post('/send-message',[UserController::class,'sendMessage' ])->name('send-message');
Route::get('/update-status/{user}',[UserController::class,'updateStatus' ])->name('update-status');

Route::group(["prefix" => "admin","middleware" => "admin",],function(){

    Route::get('dashboard',[AdminController::class,'dashboard'])->name('admin.dashboard');
    Route::get('logout',[AdminController::class,'logout'])->name('admin.logout');



    Route::get('/metiers', [AdminController::class,'metiers'])->name('admin.metiers');

    Route::get('/add-metier', [AdminController::class,'addMetier'])->name('admin.add-metier');
    Route::post('/add-metier', [AdminController::class,'insertMetier'])->name('admin.insert-metier');

    Route::get('/edit-metier/{id}', [AdminController::class,'editMetier'])->name('admin.edit-metier');
    Route::post('/edit-metier', [AdminController::class,'updateMetier'])->name('admin.update-metier');
    Route::get('/delete-metier/{id}', [AdminController::class,'deleteMetier'])->name('admin.delete-metier');


    
    // Chantier Routes for Admin
    Route::get('/chantiers',[AdminController::class,'chantiers'])->name('admin.chantiers');
    Route::get('add-chantier',[AdminController::class,'addChantier'])->name('admin.add-chantier');
    Route::post('add-chantier',[AdminController::class,'insertChantier'])->name('admin.insert-chantier');
    Route::get('edit-chantier/{id}',[AdminController::class,'editChantier'])->name('admin.edit-chantier');
    Route::post('edit-chantier',[AdminController::class,'updateChantier'])->name('admin.update-chantier');
    Route::get('delete-chantier/{id}',[AdminController::class,'deleteChantier'])->name('admin.delete-chantier');

    Route::get('chantier-details/{id}',[AdminController::class,'chantierDetails'])->name('admin.chantier-details');
    Route::post('add-tache-chantier',[AdminController::class,'insertTacheChantier'])->name('admin.insert-tache-chantier');
    Route::get('delete-tache-chantier/{id}',[AdminController::class,'deleteTacheChantier'])->name('admin.delete-tache-chantier');
    Route::get('edit-tache-chantier/{id}',[AdminController::class,'editTacheChantier'])->name('admin.edit-tache-chantier');
    Route::post('edit-tache-chantier',[AdminController::class,'updateTacheChantier'])->name('admin.update-tache-chantier');



    // Famille Routes for Admin
    Route::get('/familles', [AdminController::class,'familles'])->name('admin.familles');

    Route::get('/add-famille', [AdminController::class,'addFamille'])->name('admin.add-famille');
    Route::post('/add-famille', [AdminController::class,'insertFamille'])->name('admin.insert-famille');

    Route::get('/edit-famille/{id}', [AdminController::class,'editFamille'])->name('admin.edit-famille');
    Route::post('/edit-famille', [AdminController::class,'updateFamille'])->name('admin.update-famille');
    Route::get('/delete-famille/{id}', [AdminController::class,'deleteFamille'])->name('admin.delete-famille');

    Route::get('/famille-details/{id}', [AdminController::class,'detailsFamille'])->name('admin.famille-details');



    // Famille Routes for Admin
    Route::get('/lieux', [AdminController::class,'lieux'])->name('admin.lieux');

    Route::get('/add-lieu', [AdminController::class,'addLieu'])->name('admin.add-lieu');
    Route::post('/add-lieu', [AdminController::class,'insertLieu'])->name('admin.insert-lieu');

    Route::get('/edit-lieu/{id}', [AdminController::class,'editLieu'])->name('admin.edit-lieu');
    Route::post('/edit-lieu', [AdminController::class,'updateLieu'])->name('admin.update-lieu');
    Route::get('/delete-lieu/{id}', [AdminController::class,'deleteLieu'])->name('admin.delete-lieu');


    // Element Routes for Admin
    Route::get('/elements', [AdminController::class,'elements'])->name('admin.elements');
    Route::get('/add-element', [AdminController::class,'addElement'])->name('admin.add-element');
    Route::post('/add-element', [AdminController::class,'insertElement'])->name('admin.insert-element');
    Route::get('/edit-element/{id}', [AdminController::class,'editElement'])->name('admin.edit-element');
    Route::post('/edit-element', [AdminController::class,'updateElement'])->name('admin.update-element');
    Route::get('/delete-element/{id}', [AdminController::class,'deleteElement'])->name('admin.delete-element');

    // Stock Management Routes
    Route::get('/stock-movement/{id}', [AdminController::class, 'stockMovement'])->name('admin.stock-movement');
    Route::post('/add-stock', [AdminController::class, 'addStock'])->name('admin.add-stock');
    Route::post('/remove-stock', [AdminController::class, 'removeStock'])->name('admin.remove-stock');

    // Materiel Routes for Admin
    Route::get('/materiels', [AdminController::class,'materiels'])->name('admin.materiels');

    Route::get('/add-materiel', [AdminController::class,'addMateriel'])->name('admin.add-materiel');
    Route::post('/add-materiel', [AdminController::class,'insertMateriel'])->name('admin.insert-materiel');

    Route::get('/edit-materiel/{id}', [AdminController::class,'editMateriel'])->name('admin.edit-materiel');
    Route::post('/edit-materiel', [AdminController::class,'updateMateriel'])->name('admin.update-materiel');
    Route::get('/delete-materiel/{id}', [AdminController::class,'deleteMateriel'])->name('admin.delete-materiel');

    Route::get('/affectation-materiel-salarie', [AdminController::class,'addMaterielSalarie'])->name('admin.affectation-materiel-salarie');
    Route::post('/affectation-materiel-salarie', [AdminController::class,'insertMaterielSalarie'])->name('admin.insert-materiel-salarie');

    Route::get('/affectations', [AdminController::class,'affectations'])->name('admin.affectations');
    Route::get('/return-materiel/{id}', [AdminController::class,'returnMateriel'])->name('admin.return-materiel');
    Route::get('/delete-affectation/{id}', [AdminController::class,'deleteAffectation'])->name('admin.delete-affectation');

    Route::get('/planning', [AdminController::class,'planning'])->name('admin.planning');

    // Planning routes
    Route::get('/planning', [AdminController::class, 'planning'])->name('admin.planning');
    Route::get('/get-chantier-details/{id}', [AdminController::class, 'getChantierDetails'])->name('admin.get-chantier-details');
    Route::post('/update-chantier-dates', [AdminController::class, 'updateChantierDates'])->name('admin.update-chantier-dates');

    Route::get('/planning-salarie', [AdminController::class, 'planningSalarie'])->name('admin.planning-salarie');
    Route::get('/get-salarie-details/{id}', [AdminController::class, 'getSalarieDetails'])->name('admin.get-salarie-details');

    Route::get('/admins', [AdminController::class,'admins'])->name('admin.admins');

    Route::get('add-admin',[AdminController::class,'addAdmin'])->name('admin.add-admin');
    Route::post('add-admin',[AdminController::class,'insertAdmin'])->name('admin.insert-admin');

    Route::get('/edit-admin/{id}', [AdminController::class,'editAdmin'])->name('admin.edit-admin');
    Route::post('edit-admin', [AdminController::class,'updateAdmin'])->name('admin.update-admin');
    Route::get('/delete-admin/{id}', [AdminController::class,'deleteAdmin'])->name('admin.delete-admin');

    
    // Employee Routes for Admin
    Route::get('manage-employees',[AdminController::class,'manageEmployees'])->name('admin.manage-employees');

    Route::get('add-employee',[AdminController::class,'addEmployee'])->name('admin.add-employee');
    Route::post('add-employee',[AdminController::class,'insertEmployee'])->name('admin.insert-employee');
    Route::get('edit-employee/{id}',[AdminController::class,'editEmployee'])->name('admin.edit-employee');
    Route::post('edit-employee',[AdminController::class,'updateEmployee'])->name('admin.update-employee');
    Route::get('delete-employee/{id}',[AdminController::class,'deleteEmployee'])->name('admin.delete-employee');



    //Product Routes for Admin
    Route::get('product-report',[AdminController::class,'productReport'])->name('admin.product-report');
    
    Route::get('add-product',[AdminController::class,'addProduct'])->name('admin.add-product');
    Route::post('add-product',[AdminController::class,'insertProduct'])->name('admin.insert-product');
    Route::get('edit-product/{id}',[AdminController::class,'editProduct'])->name('admin.edit-product');
    Route::post('edit-product',[AdminController::class,'updateProduct'])->name('admin.update-product');
    Route::get('delete-product/{id}',[AdminController::class,'deleteProduct'])->name('admin.delete-product');


    Route::get('product-details/{id}',[AdminController::class,'productDetails'])->name('admin.product-details');


    Route::get('notifications',[AdminController::class,'notifications'])->name('admin.notifications');
    Route::get('add-notification',[AdminController::class,'addNotification'])->name('admin.add-notification');
    Route::post('add-notification',[AdminController::class,'insertNotification'])->name('admin.insert-notification');
    Route::get('edit-notification/{id}',[AdminController::class,'editNotification'])->name('admin.edit-notification');
    Route::post('edit-notification',[AdminController::class,'updateNotification'])->name('admin.update-notification');
    Route::get('delete-notification/{id}',[AdminController::class,'deleteNotification'])->name('admin.delete-notification');

    Route::get('employee/{id}/notifications', [AdminController::class, 'employeeNotifications'])->name('admin.employee-notifications');




    Route::get('logs',[AdminController::class,'logs'])->name('admin.logs');
    Route::get('delete-log/{id}',[AdminController::class,'deleteLog'])->name('admin.delete-log');
    Route::get('generate-logs/{id}',[AdminController::class,'generateLogs'])->name('admin.generate-logs');

    Route::get('/chats',[AdminController::class,'messages' ])->name('admin.messages');
    Route::get('/chats/{id}',[AdminController::class,'addMessage' ])->name('admin.add-message');

    Route::get('edit-profile',[AdminController::class,'editProfile'])->name('admin.edit-profile');
    Route::post('edit-profile',[AdminController::class,'updateProfile'])->name('admin.update-profile');


    // Planning routes
    Route::get('/planning', [AdminController::class, 'planning'])->name('admin.planning');
    Route::get('/planning-salarie', [AdminController::class, 'planningSalarie'])->name('admin.planning-salarie');
    Route::get('/get-chantier-details/{id}', [AdminController::class, 'getChantierDetails'])->name('admin.get-chantier-details');
    Route::get('/get-salarie-details/{id}', [AdminController::class, 'getSalarieDetails'])->name('admin.get-salarie-details');
    Route::post('/store-chantier-from-calendar', [AdminController::class, 'storeChantierFromCalendar'])->name('admin.store-chantier-from-calendar');

    Route::get('/comptabilite', [AdminController::class, 'comptabilite'])->name('admin.comptabilite');

    Route::get('/absences', [AdminController::class, 'absences'])->name('admin.absences');
    Route::post('/insert-absence', [AdminController::class, 'insertAbsence'])->name('admin.insert-absence');
    Route::get('/get-chantier-taches/{id}', [AdminController::class, 'getChantierTaches'])->name('admin.get-chantier-taches');
    Route::get('/edit-absence/{id}', [AdminController::class, 'editAbsence'])->name('admin.edit-absence');
    Route::post('/update-absence', [AdminController::class, 'updateAbsence'])->name('admin.update-absence');
    Route::get('/delete-absence/{id}', [AdminController::class, 'deleteAbsence'])->name('admin.delete-absence');



    Route::get('/timeline-chantier', [AdminController::class, 'timelineChantier'])->name('admin.timeline-chantier');
    Route::get('/timeline-employees', [AdminController::class, 'timelineEmployees'])->name('admin.timeline-employees');


    Route::post('/store-chantier', [AdminController::class, 'storeTimelineChantier'])->name('admin.store-timeline-chantier');
    Route::post('/update-chantier', [AdminController::class, 'updateTimelineChantier'])->name('admin.update-timeline-chantier');
    Route::post('/delete-chantier', [AdminController::class, 'deleteTimelineChantier'])->name('admin.delete-timeline-chantier');


    Route::post('/store-select-event-employee', [AdminController::class, 'storeSelectEventEmployee'])->name('admin.store-select-event-employee');
    Route::post('/delete-event-employee', [AdminController::class, 'deleteEventEmployee'])->name('admin.delete-event-employee');
    Route::post('/update-event-employee', [AdminController::class, 'updateEventEmployee'])->name('admin.update-event-employee');


    Route::post('/move-event-employee', [AdminController::class, 'moveEventEmployee'])->name('admin.move-event-employee');
    Route::post('/resize-event-employee', [AdminController::class, 'resizeEventEmployee'])->name('admin.resize-event-employee');
    Route::post('/duplicate-event-employee', [AdminController::class, 'duplicateEventEmployee'])->name('admin.duplicate-event-employee');


    Route::get('/settings', [AdminController::class, 'settings'])->name('admin.settings');
    Route::post('/store-holiday', [AdminController::class, 'storeHoliday'])->name('admin.store-holiday');
    Route::put('/update-holiday/{id}', [AdminController::class, 'updateHoliday'])->name('admin.update-holiday');
    Route::post('/toggle-holiday/{id}', [AdminController::class, 'toggleHoliday'])->name('admin.toggle-holiday');

    Route::post('/store-absence-timeline', [AdminController::class, 'storeAbsenceFromTimeline'])->name('admin.store-absence-timeline');
    Route::post('/update-absence-timeline', [AdminController::class, 'updateAbsenceFromTimeline'])->name('admin.update-absence-timeline');
    Route::post('/delete-absence-timeline', [AdminController::class, 'deleteAbsenceFromTimeline'])->name('admin.delete-absence-timeline');
    Route::post('/move-absence', [AdminController::class, 'moveAbsence'])->name('admin.move-absence');
    Route::post('/resize-absence', [AdminController::class, 'resizeAbsence'])->name('admin.resize-absence');

    Route::get('/settings', [AdminController::class, 'settings'])->name('admin.settings');
    Route::post('/store-holiday', [AdminController::class, 'storeHoliday'])->name('admin.store-holiday');
    Route::put('/update-holiday/{id}', [AdminController::class, 'updateHoliday'])->name('admin.update-holiday');
    Route::delete('/delete-holiday/{id}', [AdminController::class, 'deleteHoliday'])->name('admin.delete-holiday');
    Route::post('/toggle-holiday/{id}', [AdminController::class, 'toggleHoliday'])->name('admin.toggle-holiday');

    Route::get('element-requests', [AdminController::class, 'elementRequests'])->name('admin.element-requests');
    Route::get('approve-element-request/{id}', [AdminController::class, 'approveElementRequest'])->name('admin.approve-element-request');
    Route::post('reject-element-request', [AdminController::class, 'rejectElementRequest'])->name('admin.reject-element-request');

    Route::get('materiel-requests', [AdminController::class, 'materielRequests'])->name('admin.materiel-requests');
    Route::get('approve-materiel-request/{id}', [AdminController::class, 'approveMaterielRequest'])->name('admin.approve-materiel-request');
    Route::post('reject-materiel-request', [AdminController::class, 'rejectMaterielRequest'])->name('admin.reject-materiel-request');

    Route::post('/reorder-employees', [AdminController::class, 'reorderEmployees'])->name('admin.reorder-employees');

    Route::get('/resources-timeline', [AdminController::class, 'getResourcesTimeline'])->name('admin.resources-timeline');


    Route::post('get-chantier-last-color', [AdminController::class, 'getChantierLastColor'])->name('admin.get-chantier-last-color');


});

Route::group(["prefix" => "employee","middleware" => "employee",],function(){
    

    Route::get('dashboard',[EmployeeController::class,'dashboard'])->name('employee.dashboard');
    Route::get('logout',[EmployeeController::class,'logout'])->name('employee.logout');


    Route::get('edit-profile',[EmployeeController::class,'editProfile'])->name('employee.edit-profile');
    Route::post('edit-profile',[EmployeeController::class,'updateProfile'])->name('employee.update-profile');


    Route::get('elements', [EmployeeController::class, 'elements'])->name('employee.elements');
    Route::post('request-element', [EmployeeController::class, 'requestElement'])->name('employee.request-element');
    Route::get('my-requests', [EmployeeController::class, 'myRequests'])->name('employee.my-requests');


    Route::get('materiels', [EmployeeController::class, 'materiels'])->name('employee.materiels');
    Route::post('request-materiel', [EmployeeController::class, 'requestMateriel'])->name('employee.request-materiel');
    Route::get('my-materiel-requests', [EmployeeController::class, 'myMaterielRequests'])->name('employee.my-materiel-requests');









    Route::post('get-chantier-last-color', [EmployeeController::class, 'getChantierLastColor'])->name('employee.get-chantier-last-color');
    Route::post('/reorder-employees', [EmployeeController::class, 'reorderEmployees'])->name('employee.reorder-employees');
    Route::post('/store-absence-timeline', [EmployeeController::class, 'storeAbsenceFromTimeline'])->name('employee.store-absence-timeline');
    Route::post('/move-absence', [EmployeeController::class, 'moveAbsence'])->name('employee.move-absence');
    Route::post('/resize-absence', [EmployeeController::class, 'resizeAbsence'])->name('employee.resize-absence');
    Route::post('/update-absence-timeline', [EmployeeController::class, 'updateAbsenceFromTimeline'])->name('employee.update-absence-timeline');
    Route::post('/delete-absence-timeline', [EmployeeController::class, 'deleteAbsenceFromTimeline'])->name('employee.delete-absence-timeline');
    Route::post('/update-event-employee', [EmployeeController::class, 'updateEventEmployee'])->name('employee.update-event-employee');
    Route::post('/delete-event-employee', [EmployeeController::class, 'deleteEventEmployee'])->name('employee.delete-event-employee');
    Route::post('/move-event-employee', [EmployeeController::class, 'moveEventEmployee'])->name('employee.move-event-employee');
    Route::post('/resize-event-employee', [EmployeeController::class, 'resizeEventEmployee'])->name('employee.resize-event-employee');
    Route::post('/duplicate-event-employee', [EmployeeController::class, 'duplicateEventEmployee'])->name('employee.duplicate-event-employee');
    Route::post('/store-select-event-employee', [EmployeeController::class, 'storeSelectEventEmployee'])->name('employee.store-select-event-employee');

});

Route::group(["prefix" => "couvreur","middleware" => "couvreur",],function(){
    

    Route::get('dashboard',[CouvreurController::class,'dashboard'])->name('couvreur.dashboard');
    Route::get('logout',[CouvreurController::class,'logout'])->name('couvreur.logout');


    Route::get('edit-profile',[CouvreurController::class,'editProfile'])->name('couvreur.edit-profile');
    Route::post('edit-profile',[CouvreurController::class,'updateProfile'])->name('couvreur.update-profile');


    Route::get('elements', [CouvreurController::class, 'elements'])->name('couvreur.elements');
    Route::post('request-element', [CouvreurController::class, 'requestElement'])->name('couvreur.request-element');
    Route::get('my-requests', [CouvreurController::class, 'myRequests'])->name('couvreur.my-requests');


    Route::get('materiels', [CouvreurController::class, 'materiels'])->name('couvreur.materiels');
    Route::post('request-materiel', [CouvreurController::class, 'requestMateriel'])->name('couvreur.request-materiel');
    Route::get('my-materiel-requests', [CouvreurController::class, 'myMaterielRequests'])->name('couvreur.my-materiel-requests');



    Route::post('get-chantier-last-color', [CouvreurController::class, 'getChantierLastColor'])->name('couvreur.get-chantier-last-color');
    Route::post('/reorder-employees', [CouvreurController::class, 'reorderEmployees'])->name('couvreur.reorder-employees');
    Route::post('/store-absence-timeline', [CouvreurController::class, 'storeAbsenceFromTimeline'])->name('couvreur.store-absence-timeline');
    Route::post('/move-absence', [CouvreurController::class, 'moveAbsence'])->name('couvreur.move-absence');
    Route::post('/resize-absence', [CouvreurController::class, 'resizeAbsence'])->name('couvreur.resize-absence');
    Route::post('/update-absence-timeline', [CouvreurController::class, 'updateAbsenceFromTimeline'])->name('couvreur.update-absence-timeline');
    Route::post('/delete-absence-timeline', [CouvreurController::class, 'deleteAbsenceFromTimeline'])->name('couvreur.delete-absence-timeline');
    Route::post('/update-event-employee', [CouvreurController::class, 'updateEventEmployee'])->name('couvreur.update-event-employee');
    Route::post('/delete-event-employee', [CouvreurController::class, 'deleteEventEmployee'])->name('couvreur.delete-event-employee');
    Route::post('/move-event-employee', [CouvreurController::class, 'moveEventEmployee'])->name('couvreur.move-event-employee');
    Route::post('/resize-event-employee', [CouvreurController::class, 'resizeEventEmployee'])->name('couvreur.resize-event-employee');
    Route::post('/duplicate-event-employee', [CouvreurController::class, 'duplicateEventEmployee'])->name('couvreur.duplicate-event-employee');
    Route::post('/store-select-event-employee', [CouvreurController::class, 'storeSelectEventEmployee'])->name('couvreur.store-select-event-employee');



});