<?php $__env->startSection('title'); ?> Details Chantier <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<style>

.img-chantier {
    width: auto;
}

</style>





<div class="intro-y mb-3 flex items-center">
        
        <div class="row">
            <div class="col-4 mb-4 mb-xl-0">
            <h2 class="mr-auto text-lg font-medium">Détail du Chantier</h2>
            </div>

            <div class="col-4">
                <div class="justify-content-end d-flex">
                    
        
                </div>			 
            </div>
            <div class="col-4 mb-6 mb-xl-0">
            <nav aria-label="breadcrumb" class="breadcrumb-header float-start float-lg-end">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="/">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="/admin/chantiers">Chantiers</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Détail du Chantier
                    </li>
                </ol>
            </nav>
        </div>


        </div>

    </div>




    <div class="row mb-3 card pt-3">
        <div class="col-md-12 position-relative">
            

                
                    <div class="row">

                        <div class="col-md-6 mb-1">

                            <div class="ml-xl-4 mt-3">
                                <h1 class="text-primary"><?php echo e($chantier->nom); ?></h1>
                                <h3 class="font-weight-500 mb-xl-4 text-primary"><?php echo e($chantier->adresse); ?></h3>
                            </div>  

                            <div class="card">
                                <div class="card-body">
            
                                    <div id="detailedReports" class="mt-5 carousel slide detailed-report-carousel position-static pt-2" data-ride="carousel">
                                        <div class="carousel-inner">
                                    

                                        <?php if($chantier->photo && !empty($chantier->photo)): ?>
                                            <?php $i=0; ?>
                                            <?php $__currentLoopData = $chantier->photo; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php $i++; ?>
                                                <div class="carousel-item <?php echo e($i == 1 ? 'active' : ''); ?>">
                                                    <div class="row">
                                                        <?php if(file_exists(public_path('uploads/' . $photo))): ?>
                                                            <img src="<?php echo e(asset('uploads/' . $photo)); ?>" alt="Photo" class="img-fluid rounded mr-1"/>
                                                        <?php else: ?>
                                                            <img src="<?php echo e(asset('assets/images/no_image.png')); ?>" alt="No Image" class="img-fluid rounded mr-1"/>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php else: ?>
                                            <div class="carousel-item active">
                                                <div class="row">
                                                    <img src="<?php echo e(asset('assets/images/no_image.png')); ?>" alt="No Images" class="img-fluid rounded" height="200" width="auto"/>
                                                </div>
                                            </div>
                                        <?php endif; ?>

                                        </div>
                                        
                                        <a class="carousel-control-prev" href="#detailedReports" role="button" data-slide="prev">
                                        <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                                        <span class="sr-only">Précédent</span>
                                        </a>
                                        <a class="carousel-control-next" href="#detailedReports" role="button" data-slide="next">
                                        <span class="carousel-control-next-icon" aria-hidden="true"></span>
                                        <span class="sr-only">Suivant</span>
                                        </a>

                                    </div>
                                </div>
                            </div>
                        </div>

                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-body">
                            
                                <input type="hidden" name="id" value="<?php echo e($chantier->id); ?>">
                                <div class="form-group">
                                    <label for="nom">Nom Chantier</label>
                                    <p class="font-weight-bold"><?php echo e($chantier->nom); ?> </p>
                                </div>
                                
                                <div class="form-group">
                                    <label for="adresse">Adresse</label>
                                    <p class="font-weight-bold"><?php echo e($chantier->adresse); ?> </p>
                                </div>

                                <div class="form-group">
                                    <label for="date_de_debut">Date de debut</label>
                                    <p class="font-weight-bold"><?php echo e($chantier->date_de_debut); ?> </p>
                                </div>
                                
                                <div class="form-group">
                                    <label for="date_de_fin">Date de Fin Théorique</label>
                                    <p class="font-weight-bold"><?php echo e($chantier->date_de_fin); ?> </p>
                                </div>
                                
                                <?php if($chantier->date_fin_reelle): ?>
                                <div class="form-group">
                                    <label for="date_de_fin">Date de Fin Réelle</label>
                                    <p class="font-weight-bold"><?php echo e($chantier->date_fin_reelle); ?> </p>
                                </div>
                                <?php endif; ?>

                                <div class="form-group">
                                    <label for="date_de_fin">Nombre de jours Théoriques</label>
                                    <p class="font-weight-bold"><?php echo e($chantier->nbjours); ?> </p>
                                </div>
                                
                                <?php if($chantier->date_fin_reelle): ?>
                                <div class="form-group">
                                    <label for="date_de_fin">Nombre de jours Réels</label>
                                    <p class="font-weight-bold"><?php echo e($chantier->nbjours_reelle); ?> </p>
                                </div>
                                <?php endif; ?>
                                
                                <?php if($chantier->date_fin_reelle): ?>
                                <div class="form-group">
                                    <?php
                                        $difference = $chantier->nbjours - $chantier->nbjours_reelle;
                                    ?>
                                    
                                    <?php if($difference < 0): ?>
                                        
                                        <span class="badge badge-danger text-white">
                                            <i class="fa-solid fa-circle-exclamation"></i> <?php echo e($difference); ?> jours de retard
                                        </span>
                                    <?php else: ?>
                                        <span class="badge badge-success text-white">
                                            <i class="fa-solid fa-circle-check"></i> <?php echo e($difference); ?> jours en avance
                                        </span>
                                    <?php endif; ?>
                                    </div>
                                <?php endif; ?>
                            
                            </div>
                            
                        </div>
                        <div class="d-flex gap-2">
                            
                            <a href='<?php echo e(route("admin.edit-chantier", $chantier->id)); ?>' class="btn btn-primary"> Modifier Chantier </a>
                            <a data-id="<?php echo e($chantier->id); ?>" class="btn btn-danger delete" href="javascript::void();">
                                <i class="fa-solid fa-trash"></i> Supprimer Chantier
                            </a>
                            
                        </div>
                    </div>


    

                </div>
            
        </div>
    </div>
   





    <!-- Add Tache Modal -->
    <div class="modal fade" id="addTacheModal" tabindex="-1" role="dialog" aria-labelledby="addTacheModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="addTacheModalLabel">Ajouter une Tache</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                        
                    <form method="post" enctype="multipart/form-data" autocomplete="off" action="<?php echo e(route('admin.insert-tache-chantier')); ?>" id="addTacheForm">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="chantier_id" value="<?php echo e($chantier->id); ?>">
                        <div class="form-group">
                            <label for="nom">Tache</label>
                            <input name="nom" id="nom" type="text" class="form-control" required>
                        </div>
                        
                        <div class="form-group">
                            <label for="description">Description</label>
                            <textarea name="description" id="description" class="form-control" rows="3"></textarea>
                        </div>

                        <div class="form-group">
                            <label for="nb_jours">Date de debut</label>
                            <input name="date_debut" id="date_debut" type="date" class="form-control" 
                                min="<?php echo e($chantier->date_debut); ?>" 
                                max="<?php echo e($chantier->date_fin); ?>" 
                                required>
                        </div>

                        <div class="form-group">
                            <label for="nb_jours">Date de fin</label>
                            <input name="date_fin" id="date_fin" type="date" class="form-control" 
                                min="<?php echo e($chantier->date_debut); ?>" 
                                max="<?php echo e($chantier->date_fin); ?>" 
                                required>
                        </div>

                        
                        <div class="form-group">
                            <label for="status">Statut</label>
                            <select id="status" name="status" class="form-control mb-3">
                                <option value="pending">En Attente</option>
                                <option value="in_progress">En Cours</option>
                                <option value="completed">Complété</option>
                            </select>
                        </div>


                        <div class="form-group"  style="width:100%;">
                            <label for="salaries">Salariés</label>
                            <br>
                            <select id="employees" name="employees[]" class="js-example-basic-multiple form-control w-100" style="width:100%;" multiple="multiple">
                            <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($employee->id); ?>"><?php echo e($employee->prenom); ?> <?php echo e($employee->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>


                        <div class="form-group">
                            <input type="file" name="photos[]" multiple class="image-preview-filepond filepond" id="photo-input">
                            <div id="photo-preview" class="d-flex flex-wrap mt-2"></div>
                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Fermer</button>
                            <button type="submit" class="btn btn-primary">Ajouter Nouvelle Tache</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
   
    

    <div class="row">

        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-4">
                        <h2 class="card-title mb-0">Liste Des Taches</h2>
                        <div class="d-flex gap-2">
                            <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#addTacheModal">
                                <i class="fa fa-plus"></i> Ajouter une Tache
                            </button>
                            
                            
                        </div>
                    </div>
                    <div class="table-responsive">
                        <table class="table table-striped table-borderless datatables" id="table1">
                            <thead>
                            <tr>
                                <th></th>
                                <th>Tache</th>
                                <th>Date de Debut</th>
                                <th>Date de Fin</th>
                                <th>Nombre de jours</th>
                                <th>Salariés</th>
                                <th>Status</th>
                                <th></th>
                            </tr>  
                            </thead>
                            <tbody>
                               
                            <?php $total_nb_jours = 0; ?>
                            <?php if(count($taches) > 0 ): ?>
                                <?php $__currentLoopData = $taches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tache): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> 
                                <?php $total_nb_jours += $tache->nb_jours; ?>
                                <tr>
                                    <td class="text-center">
                                        <?php if($tache->photo && !empty($tache->photo) && isset($tache->photo[0]) && file_exists(public_path('uploads/' . $tache->photo[0]))): ?>
                                            <img src="<?php echo e(asset('uploads/' . $tache->photo[0])); ?>" alt="Photo" class="img-fluid rounded" height="200" width="auto"/>
                                        <?php else: ?>
                                            <img src="<?php echo e(asset('assets/images/no_image.png')); ?>" alt="No Image" class="img-fluid rounded" height="200" width="auto"/>
                                        <?php endif; ?>
                                    </td>
                                    <td class="font-weight-bold"><?php echo e($tache->nom); ?></td>
                                    <td><div class="font-weight-bold"><?php echo e($tache->date_debut); ?></div></td>
                                    <td><div class="font-weight-bold"><?php echo e($tache->date_fin); ?></div></td>
                                    <td><div class="badge badge-primary"><?php echo e($tache->nb_jours); ?></div></td>
                                    <td class="font-weight-medium">
                                        <?php if($tache->employees): ?>
                                            <?php $__currentLoopData = $tache->employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employeeId): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php
                                                    $employee = \App\Models\User::find($employeeId);
                                                ?>
                                                <?php if($employee): ?>
                                                    <span class='badge badge-primary text-white mr-1'><?php echo e($employee->prenom); ?> <?php echo e($employee->name); ?></span>, 
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($tache->status == 'pending'): ?>
                                            <span class="badge badge-warning text-white"><i class="fa-solid fa-hourglass-half"></i> En Attente</span>
                                        <?php elseif($tache->status == 'in_progress'): ?>
                                            <span class="badge badge-info text-white"><i class="fa-solid fa-bars-progress"></i> En Cours</span>
                                        <?php elseif($tache->status == 'completed'): ?>
                                            <span class="badge badge-success text-white"><i class="fa-solid fa-circle-check"></i> Complété</span>
                                        <?php endif; ?>
                                    </td>


                                    <td>

                                    <a href='<?php echo e(route("admin.edit-tache-chantier", $tache->id)); ?>' class="text-info  mr-2"><i class="fa-solid fa-pen-to-square"></i> Modifier </a>
					                <a data-tache-id="<?php echo e($tache->id); ?>" class="text-danger delete-tache" href="javascript::void();"><i class="fa-solid fa-trash"></i> Supprimer </a>
                                    
                                    </td>

                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                <tr>
                                    <td colspan="5"><h1>Aucune tache a afficher</h1></td>
                                </tr>
                            <?php endif; ?>
                            
                            </tbody>
                            <?php if(count($taches) > 0 ): ?>
                            <tfoot>
                            <tr>
                                <td class="font-weight-bold">Nombre de jours total </td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td><div class="badge badge-primary text-white"><?php echo e($total_nb_jours); ?></div></td>
                                <td></td>
                                <td></td>
                                <td></td>

                            </tr>
                            </tfoot>   
                            <?php endif; ?>
                        </table>
                    </div>
                </div>
            </div>
        </div>

    </div>


    


<?php $__env->stopSection(); ?>


<?php $__env->startSection('script'); ?>



<script type="text/javascript">
	$('.delete').click(function(){
	    
		var dataId = $(this).attr("data-id");
		Swal.fire({
		  title: "Are you sure?",
		  text: "Once you confirm, this action cannot be undone!",
		  icon: "warning",
		  showCancelButton: true,
		  confirmButtonColor: "#3085d6",
		  cancelButtonColor: "#d33",
		  confirmButtonText: "Yes, delete!"
		}).then((result) => {
		  if (result.isConfirmed) {
		    window.open(`<?php echo e(route("admin.delete-chantier", [":dataId"])); ?>`.replace(':dataId', dataId),"_self");
		  }
		});
	});

    $('.delete-tache').click(function(){
	    
		var datatacheId = $(this).attr("data-tache-id");
		Swal.fire({
		  title: "Are you sure?",
		  text: "Once you confirm, this action cannot be undone!",
		  icon: "warning",
		  showCancelButton: true,
		  confirmButtonColor: "#3085d6",
		  cancelButtonColor: "#d33",
		  confirmButtonText: "Yes, delete!"
		}).then((result) => {
		  if (result.isConfirmed) {
		    window.open(`<?php echo e(route("admin.delete-tache-chantier", [":datatacheId"])); ?>`.replace(':datatacheId', datatacheId),"_self");
		  }
		});
	});
</script>

<script>
    document.getElementById('photo-input').addEventListener('change', function(event) {
        const previewContainer = document.getElementById('photo-preview');
        previewContainer.innerHTML = ''; // Clear previous previews

        const files = event.target.files;
        for (let i = 0; i < files.length; i++) {
            const file = files[i];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    const img = document.createElement('img');
                    img.src = e.target.result;
                    img.alt = 'Preview';
                    img.className = 'img-chantier rounded mr-2 mb-2';
                    img.height = 200; // Set height to 200
                    img.width = 200; // Set width to auto
                    previewContainer.appendChild(img); // Append to preview container
                }
                reader.readAsDataURL(file); // Read the file as a data URL
            }
        }
    });
</script>

<script>
$(document).ready(function() {
    // Date validation for task dates
    $('#date_debut').change(function() {
        var startDate = $(this).val();
        $('#date_fin').attr('min', startDate);
    });

    $('#date_fin').change(function() {
        var endDate = $(this).val();
        $('#date_debut').attr('max', endDate);
    });

    // Show error if dates are invalid
    $('form').submit(function(e) {
        var dateDebut = new Date($('#date_debut').val());
        var dateFin = new Date($('#date_fin').val());
        var chantierDebut = new Date('<?php echo e($chantier->date_de_debut); ?>');
        var chantierFin = new Date('<?php echo e($chantier->date_de_fin); ?>');

        if (dateDebut < chantierDebut || dateDebut > chantierFin || 
            dateFin < chantierDebut || dateFin > chantierFin || 
            dateDebut > dateFin) {
            e.preventDefault();
            Swal.fire({
                icon: 'error',
                title: 'Erreur de date',
                text: 'Les dates de la tâche doivent être comprises entre les dates du chantier et la date de début doit être antérieure à la date de fin.',
            });
        }
    });
});
</script>



<script>
  $('#table1').DataTable({
        dom: 'Bfrtip',
        language: {
            url: '<?php echo e(asset("assets/fr-FR.json")); ?>'
        },
        buttons: [
            {
				title:'Détail du Chantier <?php echo e($chantier->nom); ?>',
                extend: 'copy',
                exportOptions: {
                    columns: [1, 2, 3, 4, 5, 6]
                }
            },
            {
				title:'Détail du Chantier <?php echo e($chantier->nom); ?>',
                extend: 'csv',
                exportOptions: {
                    columns: [1, 2, 3, 4, 5, 6]
                }
            },
            {
				title:'Détail du Chantier <?php echo e($chantier->nom); ?>',
                extend: 'excel',
                exportOptions: {
                    columns: [1, 2, 3, 4, 5, 6]
                }
            },
            {
				title:'Détail du Chantier <?php echo e($chantier->nom); ?>',
                extend: 'pdf',
				text: 'PDF',
                exportOptions: {
					modifier: {
                    page: 'current'
                },
                    columns: [1, 2, 3, 4, 5, 6]
                }
            },
            {
				title: '<h2 style="text-align: center;">Détail du Chantier <?php echo e($chantier->nom); ?></h2>', // Title centered
				extend: 'print',
				exportOptions: {
					columns: [ 1, 2, 3, 4, 5, 6]
				},
				customize: function (win) {
					$(win.document.body)
						.css('font-size', '10pt') // Optional: Adjust font size
						.prepend(
							'<div style="text-align: center;"><img src="<?php echo e(asset('assets/images/RenovImmo-long.png')); ?>" style="width: 80%; margin-bottom: 20px;" /></div>'
						);

					// Style the title
					$(win.document.body).find('h1')
						.css('text-align', 'center') // Ensure the title is centered
						.css('margin-bottom', '20px'); // Optional: Add spacing below the title
						
						
					// Style the table explicitly
					$(win.document.body).find('table').addClass('table table-bordered table-striped');
				}
			},

            'colvis'
        ]
    });
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u400861240/domains/zydevgroup.com/public_html/renovimmo/resources/views/admin/chantier-details.blade.php ENDPATH**/ ?>