<?php $__env->startSection('title'); ?> Chronologie Chantiers <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<style>
a.fc-timeline-slot-cushion.fc-scrollgrid-sync-inner {
    color: black;
}
        /* Tache container styling */
        .tache-item {
            border: 1px solid #dee2e6;
            background: #f8f9fa;
            border-radius: 8px;
            margin-bottom: 15px;
            padding: 15px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
            transition: all 0.3s ease;
        }

        .tache-item:hover {
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
            border-color: #025182;
        }

        /* Task header */
        .tache-item .row {
            background: #f8f9fa;
            border-radius: 4px;
            padding: 10px;
            margin-bottom: 15px;
        }

        /* Form controls spacing */
        .tache-item .form-group {
            margin-bottom: 15px;
        }

        /* Label styling */
        .tache-item label {
            font-weight: 500;
            color: #495057;
        }

        /* Remove button styling */
        .remove-tache {
            background: #dc3545;
            border: none;
            padding: 6px 12px;
            border-radius: 4px;
            transition: all 0.2s ease;
        }

        .remove-tache:hover {
            background: #c82333;
            transform: translateY(-1px);
        }

        /* Add task button styling */
        #addTacheBtn {
            background: #025182;
            color: white;
            border: none;
            padding: 8px 20px;
            border-radius: 4px;
            transition: all 0.2s ease;
        }

        #addTacheBtn:hover {
            background: #01406b;
            transform: translateY(-1px);
        }

        /* Select2 styling */
        .select2-container--bootstrap4 .select2-selection {
            height: 40px !important;
            border-radius: 4px;
            border: 1px solid #ced4da;
        }

        .select2-container--bootstrap4 .select2-selection--multiple {
            min-height: 40px !important;
        }

        .select2-container--bootstrap4 .select2-selection__rendered {
            padding: 8px 12px;
        }

        .select2-container--bootstrap4 .select2-selection__choice {
            background-color: #025182;
            border: 1px solid #025182;
            color: white;
            border-radius: 20px;
            padding: 0 10px;
            margin: 4px;
        }

        .select2-container--bootstrap4 .select2-selection__choice__remove {
            color: white;
            font-size: 12px;
            padding: 0 4px;
        }

        /* Date input styling */
        .form-control[type="date"] {
            background-color: white;
            border: 1px solid #ced4da;
            padding: 8px 12px;
            border-radius: 4px;
        }

        /* Textarea styling */
        .tache-description {
            min-height: 100px;
            resize: vertical;
        }

        /* Responsive adjustments */
        @media (max-width: 768px) {
            .tache-item {
                margin-bottom: 10px;
            }
            
            .tache-item .row {
                margin-bottom: 10px;
            }
            
            .remove-tache {
                padding: 4px 8px;
            }
        }
    </style>

<div class="d-flex justify-content-between align-items-center mb-4">
    <div class="btn-group mr-3" role="group" aria-label="Vue">
            
        <div class="btn-group mr-3" role="group" aria-label="Vue">
        
            <a href="<?php echo e(route('admin.timeline-employees')); ?>" class="btn btn-outline-primary"><i class="fas fa-hard-hat"></i> Vue Par Salariés</a>
            <a href="<?php echo e(route('admin.planning')); ?>" class="btn btn-outline-primary"><i class="fa-regular fa-calendar"></i> Calendrier Chantiers</a>
            <a href="<?php echo e(route('admin.timeline-chantier')); ?>" class="btn btn-primary"><i class="fa-solid fa-timeline"></i> Chronologie des Chantiers</a>
        </div>
    </div>
    <div class="d-flex align-items-center">
        
        <button id="openNewChantierModal" class="btn btn-secondary text-white" style="background-color: #01152b;">
            <i class="fas fa-plus"></i> Ajouter Nouveau Chantier
        </button>
    </div>
</div>


  

<!-- New Chantier Modal -->
<div class="modal fade" id="newChantierModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Ajouter Nouveau Chantier</h5>
                <button type="button" class="close" data-dismiss="modal">
                    <span>&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="newChantierForm">
                    <div class="form-group">
                        <div class="row">
                            <div class="col-md-6 mb-2">
                                <label>Nom du chantier</label>
                                <input type="text" class="form-control" id="nom" name="nom" required>
                            </div>
                            <div class="col-md-6 mb-2">
                                <label>Adresse</label>
                                <input type="text" class="form-control" id="adresse" name="adresse">
                            </div>
                            <div class="col-md-6 mb-2">
                                <label>Date de début</label>
                                <input type="date" class="form-control" id="date_de_debut" name="date_de_debut" required>
                            </div>
                            <div class="col-md-6 mb-2">
                                <label>Date de fin</label>
                                <input type="date" class="form-control" id="date_de_fin" name="date_de_fin" required>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Taches Section -->
                    <div class="form-group">
                        <label>Tâches</label>
                        <div id="tachesContainer">
                            <div class="tache-item">
                                <div class="row bg-light mb-2">
                                    
                                    <div class="col-md-11">
                                        <div class="row">
                                            <div class="col-md-12 mb-2">
                                                <label>Nom de la tâche:</label>
                                                <input type="text" class="form-control tache-nom" placeholder="Nom de la tâche" required>
                                            </div>
                                            <div class="col-md-12 mb-2">
                                                <label>Description:</label>
                                                <textarea class="form-control tache-description" placeholder="Description" ></textarea>
                                            </div>
                                            <div class="col-md-4 mb-2">
                                                <label>Date début de tâche:</label>
                                                <input type="date" class="form-control tache-date-debut" placeholder="Date début"  required>
                                            </div>
                                            <div class="col-md-4 mb-2">
                                                <label>Date fin de tâche:</label>
                                                <input type="date" class="form-control tache-date-fin" placeholder="Date fin" required>
                                            </div>

                                            <div class="col-md-4 mb-2">
                                                <label for="status">Statut</label>
                                                <select id="status" name="status" class="form-control mb-3">
                                                    <option value="pending">En Attente</option>
                                                    <option value="in_progress">En Cours</option>
                                                    <option value="completed">Complété</option>
                                                </select>
                                            </div>

                                            <div class="col-md-12 mb-2">
                                                <label>Salariés Affectés:</label>
                                                <select name="employees[]" class="tache-employees js-example-basic-multiple form-control w-100" style="width:100%;" multiple="multiple">
                                                    <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($employee->id); ?>"><?php echo e($employee->name); ?> <?php echo e($employee->prenom); ?> - 
                                                        <?php
                                                            $metierNames = [];
                                                            if ($employee->primary_metiers) {
                                                                $metierIds = json_decode($employee->primary_metiers, true);
                                                                foreach ($metierIds as $id) {
                                                                    $metier = \App\Models\Metier::find($id);
                                                                    if ($metier) {
                                                                        $metierNames[] = $metier->nom;
                                                                    }
                                                                }
                                                            }
                                                        ?>
                                                        <?php echo e(implode(', ', $metierNames)); ?>

                                                    </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>

                                        </div>
                                    </div>

                                    <div class="col-md-1 align-self-center">
                                        <button type="button" class="btn btn-danger btn-sm remove-tache">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </div>


                                </div>
                            </div>
                        </div>
                        <button type="button" class="btn btn-secondary mt-2" id="addTacheBtn">
                            <i class="fas fa-plus"></i> Ajouter une tâche
                        </button>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Annuler</button>
                <button type="button" class="btn btn-primary" id="saveNewChantier">Enregistrer</button>
            </div>
        </div>
    </div>
</div>



<div class="row justify-content-center">
    
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <div id='calendar'></div>
            </div>
        </div>
    </div>
</div>
</body>

<!--  Détails du Chantier modal -->
<!-- Modal Détails Chantier -->
<div class="modal fade" id="chantierModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Détails du Chantier</h5>
                <button type="button" class="close" data-dismiss="modal">
                    <span>&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Nom du chantier:</label>
                            <input type="text" class="form-control" id="chantier_nom" >
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Adresse:</label>
                            <input type="text" class="form-control" id="chantier_adresse" >
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Date de début:</label>
                            <input type="text" class="form-control" id="chantier_date_debut" >
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Date de fin:</label>
                            <input type="text" class="form-control" id="chantier_date_fin" >
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <label>Tâches:</label>
                    <div id="tachesList" class="list-group">
                        <!-- Tâches will be inserted here -->
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Annuler</button>
                <a href="#" id="editChantierBtn" class="btn btn-warning text-white"><i class="fa-solid fa-eye"></i> Details Chantier</a>
                <a href="#" class="btn btn-success text-white"><i class="fa-solid fa-save"></i> Mettre à jour</a>
                <a href="#" id="deleteChantierBtn" class="btn btn-danger text-white"><i class="fa-solid fa-trash"></i> Supprimer Chantier</a>
            </div>
        </div>
    </div>
</div>

    
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>

<script>

    function formatDateForInput(dateStr) {
        if (!dateStr) return '';
        const date = new Date(dateStr);
        return date.toISOString().split('T')[0];
    }

    $('#openNewChantierModal').click(function() {
        $('#newChantierModal').modal('show');
        $('#date_de_debut').val(new Date().toISOString().split('T')[0]);
        $('#date_de_fin').val(new Date().toISOString().split('T')[0]);
    });

    // Function to add a new tache with optional dates
    function addTache(startDate = null, endDate = null) {
        const container = $('#tachesContainer');
        const tacheItem = `
            <div class="tache-item">
                <div class="row bg-light mb-2">

                    <div class="col-md-11">
                        <div class="row">
                            <div class="col-md-12">
                                <label>Nom de la tâche:</label>
                                <input type="text" class="form-control tache-nom" placeholder="Nom de la tâche" required>
                            </div>
                            <div class="col-md-12 mb-2">
                                <label>Description:</label>
                                <textarea class="form-control tache-description" placeholder="Description"></textarea>
                            </div>
                            <div class="col-md-4 mb-2">
                                <label>Date début de tâche:</label>
                                <input type="date" class="form-control tache-date-debut" placeholder="Date début" required value="${formatDateForInput(startDate)}">
                            </div>
                            <div class="col-md-4 mb-2">
                                <label>Date fin de tâche:</label>
                                <input type="date" class="form-control tache-date-fin" placeholder="Date fin" required value="${formatDateForInput(endDate)}">
                            </div>

                            <div class="col-md-4 mb-2">
                                <label for="status">Statut</label>
                                <select id="status" name="status" class="form-control mb-3">
                                    <option value="pending">En Attente</option>
                                    <option value="in_progress">En Cours</option>
                                    <option value="completed">Complété</option>
                                </select>
                            </div>

                            
                            <div class="col-md-12 mb-2">
                                <label>Salariés Affectés:</label>
                                <select class="tache-employees js-example-basic-multiple form-control w-100" style="width:100%;" multiple="multiple">
                                    <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($employee->id); ?>"><?php echo e($employee->name); ?> <?php echo e($employee->prenom); ?> - 
                                        <?php
                                            $metierNames = [];
                                            if ($employee->primary_metiers) {
                                                $metierIds = json_decode($employee->primary_metiers, true);
                                                foreach ($metierIds as $id) {
                                                    $metier = \App\Models\Metier::find($id);
                                                    if ($metier) {
                                                        $metierNames[] = $metier->nom;
                                                    }
                                                }
                                            }
                                        ?>
                                        <?php echo e(implode(', ', $metierNames)); ?>

                                    </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                                            
                        </div>
                    </div>
                    <div class="col-md-1 align-self-center">
                        <button type="button" class="btn btn-danger btn-sm remove-tache">
                            <i class="fas fa-trash"></i>
                        </button>
                    </div>

                </div>
            </div>
        `;
        container.append(tacheItem);

        // Initialize Select2 for the new select element
        $(".js-example-basic-multiple").select2();
        
        // Add click handler for the remove button
        $('.remove-tache').last().on('click', function() {
            $(this).closest('.tache-item').remove();
        });
    }

    // Initialize remove handlers for existing tasks
    document.addEventListener('DOMContentLoaded', () => {
        // Add click handlers for existing remove buttons
        $('.remove-tache').on('click', function() {
            $(this).closest('.tache-item').remove();
        });
        
        // ... rest of your existing code
    });

    $('#addTacheBtn').on('click', function() {
        // Add new tache with same dates as chantier
        addTache($('#date_de_debut').val(), $('#date_de_fin').val());
    });

    $('#addTaskBtn').click(function() {
        const startDate = formatDateForInput(info.startStr);  // info is not defined here
        const endDate = formatDateForInput(info.endStr);      // info is not defined here
        addTache(startDate, endDate);
    });


    

    
    var calendar;

    function initializeCalendar() {
        var calendarEl = document.getElementById('calendar');
        
        calendar = new FullCalendar.Calendar(calendarEl, {
            themeSystem: 'bootstrap',
            locale: 'fr',
            initialView: 'resourceTimelineMonth',
            nowIndicator: true,
            headerToolbar: {
            left: 'prev,next',
            center: 'title',
            right: 'resourceTimelineDay,resourceTimelineWeek,resourceTimelineMonth'
            },
            slotLabelInterval: '24:00',
            slotLabelFormat: {
            weekday: 'long',
            month: 'numeric',
            day: 'numeric'
            },
            hiddenDays: [0, 6],
            schedulerLicenseKey: 'GPL-My-Project-Is-Open-Source',
            slotLabelDidMount: function(info) {
            const date = info.date;
            const weekday = date.toLocaleDateString('fr-FR', { weekday: 'long' });
            const datePart = date.toLocaleDateString('fr-FR', { day: '2-digit', month: '2-digit' });
            
            },
            slotMinTime: '00:00:00',
            slotMaxTime: '24:00:00',
            expandRows: true,
            editable: false,
            eventStartEditable: false,     // prevents dragging
            eventDurationEditable: false,  // prevents resizing
            selectable: true,
            resourceAreaWidth: '200px',
            resourceAreaHeaderContent: 'Chantiers',
            resources: <?php echo json_encode($chantiers->map(function($chantier) {
                return [
                    'id' => $chantier->id, 'title' => $chantier->nom, ];
            })) ?>,
            events: <?php echo json_encode($events, 15, 512) ?>,
            eventDisplay: 'block',








            select: function(info) {
                // // Get the selected resource (chantier)
                // const selectedChantier = info.resource;
                // if (!selectedChantier) return;

                // // Get chantier details
                // $.ajax({
                //     url: '<?php echo e(url("/admin/get-chantier-details")); ?>/' + selectedChantier.id,
                //     method: 'GET',
                //     success: function(chantier) {
                //         // Update modal with chantier details
                //         $('#chantier_nom').val(chantier.nom);
                //         $('#chantier_adresse').val(chantier.adresse);
                //         $('#chantier_date_debut').val(chantier.date_de_debut);
                //         $('#chantier_date_fin').val(chantier.date_de_fin);

                //         // Store the chantier ID for later use
                //         $('#chantierModal').data('chantier-id', selectedChantier.id);

                //         // Set the task dates based on selection
                //         $('.tache-date-debut').val(formatDateForInput(info.startStr));
                //         $('.tache-date-fin').val(formatDateForInput(info.endStr));

                //         // Show the modal
                //         $('#chantierModal').modal('show');
                //     },
                //     error: function() {
                //         toastr.error('Erreur lors du chargement des détails du chantier');
                //     }
                // });
            },








            displayEventEnd: true, // Show end date
            eventContent: function(arg) {
                // Return empty content to prevent default rendering
                return '';
            },










            eventDidMount: function(info) {
                // const color = info.event.extendedProps.color;
                // if (color) {
                //     info.el.style.backgroundColor = color;
                // }
                const event = info.event;
                const eventEl = info.el;

                // Clear existing content
                eventEl.innerHTML = '';

                // Create HTML content
                let html = `
                    <div class="fc-event-container" style="padding: 8px; border-radius: 4px; background-color: ${event.extendedProps.color || '#025182'}; color: #fff;">
                        <div class="fc-event-title-container" style="font-weight: bold; margin-bottom: 5px;">
                            ${event.title}
                        </div>
                        <div class="fc-event-dates" style="font-size: 0.85rem; margin-bottom: 5px;">
                            Du ${new Date(event.extendedProps.tache_start).toLocaleDateString('fr-FR')} au ${new Date(event.extendedProps.tache_end).toLocaleDateString('fr-FR')}
                        </div>
                        <div class="fc-event-employees" style="font-size: 0.8rem;">
                            <ul>
                                ${event.extendedProps.employees && event.extendedProps.employees.length > 0 ? 
                                    event.extendedProps.employees.map(emp => {
                                        const primaryMetiers = emp.primary_metiers ? emp.primary_metiers.join(', ') : '';
                                        return `<li class="" style="padding: 2px 0;">${emp.nom} (${primaryMetiers})</li>`;
                                    }).join('') : '<li>Aucun employé assigné</li>'}
                            </ul>
                        </div>
                    </div>
                `;

                // Set the HTML
                eventEl.innerHTML = html;

                // Add hover effect
                eventEl.style.cursor = 'pointer';
                eventEl.addEventListener('mouseenter', () => {
                    eventEl.style.opacity = '0.9';
                });
                eventEl.addEventListener('mouseleave', () => {
                    eventEl.style.opacity = '1';
                });
            },








            eventClick: function(info) {
                var chantierId = info.event.id;
                $.ajax({
                    url: '<?php echo e(url("/admin/get-chantier-details")); ?>/' + chantierId,
                    method: 'GET',
                    success: function(chantier) {
                        $('#chantier_nom').val(chantier.nom);
                        $('#chantier_adresse').val(chantier.adresse);
                        $('#chantier_date_debut').val(chantier.date_de_debut);
                        $('#chantier_date_fin').val(chantier.date_de_fin);
                        
                        
                        // Clear and populate tasks
                        var tachesList = $('#tachesList');
                        tachesList.empty();
                        

                        if (chantier.taches && chantier.taches.length > 0) {
                            chantier.taches.forEach(function(tache) {
                                
                                tachesList.append(`



                                    <div class="bg-light list-group-item task-item" data-task-id="${tache.id}">
                                        
                                        

                                        <div class="task-details mb-2">

                                            <div class="d-flex justify-content-between align-items-center mb-2">
                                                <h5 class="mb-0">${tache.nom ?? ''}</h5>
                                                <button class="btn btn-danger btn-sm remove-task" data-task-id="${tache.id}">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </div>

                                            <div class="row">

                                                <div class="col-md-12 mb-2">
                                                    <label>Nom de la tâche:</label>
                                                    <input type="text" class="form-control task-name" value="${tache.nom ?? ''}" required>
                                                </div>
                                                <div class="col-md-12 mb-2">
                                                    <label>Description:</label>
                                                    <textarea class="form-control task-description" placeholder="Description">${tache.description ?? ''}</textarea>
                                                </div>
                                                <div class="col-md-4 mb-2">
                                                    <label>Date début:</label>
                                                    <input type="date" class="form-control task-date-debut" value="${tache.date_debut ?? ''}" required>
                                                </div>
                                                <div class="col-md-4 mb-2">
                                                    <label>Date fin:</label>
                                                    <input type="date" class="form-control task-date-fin" value="${tache.date_fin ?? ''}" required>
                                                </div>
                                                    
                                                <div class="col-md-4 mb-2">
                                                    <label for="status">Statut</label>
                                                    <select id="status" name="status" class="form-control task-status mb-3">
                                                        <option value="pending">En Attente</option>
                                                        <option value="in_progress">En Cours</option>
                                                        <option value="completed">Complété</option>
                                                    </select>
                                                </div>
                                                <div class="col-md-12 mb-2">
                                                    <label>Salariés:</label>
                                                    <select class="tache-employees js-example-basic-multiple form-control w-100" style="width:100%;" multiple="multiple">
                                                        <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($employee->id); ?>">
                                                                <?php echo e($employee->name); ?> <?php echo e($employee->prenom); ?> - 
                                                                <?php
                                                                    $metierNames = [];
                                                                    if ($employee->primary_metiers) {
                                                                        $metierIds = json_decode($employee->primary_metiers, true);
                                                                        foreach ($metierIds as $id) {
                                                                            $metier = \App\Models\Metier::find($id);
                                                                            if ($metier) {
                                                                                $metierNames[] = $metier->nom;
                                                                            }
                                                                        }
                                                                    }
                                                                ?>
                                                                <?php echo e(implode(', ', $metierNames)); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>



                                            
                                            </div>
                                        </div>
                                    </div>



                                `);

                                // Initialize Select2 for the new select element
                                const select = tachesList.find('.js-example-basic-multiple:last').select2();

                                // Set selected employees after appending the HTML
                                if (tache.employees) {
                                    const employeeIds = typeof tache.employees === 'string' ? JSON.parse(tache.employees) : tache.employees;
                                    select.val(employeeIds).trigger('change');
                                }

                                // Set status
                                const statusSelect = tachesList.find('.task-status:last');
                                statusSelect.val(tache.status).trigger('change');

                            });


                        // Add a button to add new tasks
                        tachesList.append(`
                        
                            <div class="list-group-item add-task-section">
                                <button class="btn btn-secondary mt-2" id="addTaskBtn">
                                    <i class="fas fa-plus"></i> Ajouter une tâche
                                </button>
                            </div>
                        `);
                        } else {
                            tachesList.append('<div class="list-group-item">Aucune tâche</div>');
                        }

                        // Add task button click handler
                        $('#addTaskBtn').on('click', function() {
                            const container = $('#tachesList');
                            const taskItem = `
                                <div class="list-group-item task-item">

                                    <div class="row">

                                                <div class="col-md-12 mb-2">
                                                    <label>Nom de la tâche:</label>
                                                    <input type="text" class="form-control task-name" required>
                                                </div>
                                                <div class="col-md-12 mb-2">
                                                    <label>Description:</label>
                                                    <textarea class="form-control task-description" placeholder="Description"></textarea>
                                                </div>
                                                <div class="col-md-4 mb-2">
                                                    <label>Date début:</label>
                                                    <input type="date" class="form-control task-date-debut" required>
                                                </div>
                                                <div class="col-md-4 mb-2">
                                                    <label>Date fin:</label>
                                                    <input type="date" class="form-control task-date-fin" required>
                                                </div>
                                                    
                                                <div class="col-md-4 mb-2">
                                                    <label for="status">Statut</label>
                                                    <select id="status" name="status" class="form-control task-status mb-3">
                                                        <option value="pending">En Attente</option>
                                                        <option value="in_progress">En Cours</option>
                                                        <option value="completed">Complété</option>
                                                    </select>
                                                </div>
                                                <div class="col-md-12 mb-2">
                                                    <label>Salariés:</label>
                                                    <select class="tache-employees js-example-basic-multiple form-control w-100" style="width:100%;" multiple="multiple">
                                                        <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($employee->id); ?>">
                                                                <?php echo e($employee->name); ?> <?php echo e($employee->prenom); ?> - 
                                                                <?php
                                                                    $metierNames = [];
                                                                    if ($employee->primary_metiers) {
                                                                        $metierIds = json_decode($employee->primary_metiers, true);
                                                                        foreach ($metierIds as $id) {
                                                                            $metier = \App\Models\Metier::find($id);
                                                                            if ($metier) {
                                                                                $metierNames[] = $metier->nom;
                                                                            }
                                                                        }
                                                                    }
                                                                ?>
                                                                <?php echo e(implode(', ', $metierNames)); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>



                                            
                                            </div>


                                    <button class="btn btn-danger btn-sm remove-task">
                                        <i class="fas fa-trash"></i>
                                    </button>


                                </div>
                            `;
                            container.append(taskItem);


                            // Initialize Select2 for the new select element
                            const select = tachesList.find('.js-example-basic-multiple:last').select2();



                            // Set up remove button handler for the new task immediately
                            const removeBtn = container.find('.remove-task:last');
                            removeBtn.on('click', function() {
                                $(this).closest('.task-item').remove();
                            });
                        });

                        // Remove task button click handler for existing tasks
                        $('.task-item .remove-task').on('click', function() {
                            $(this).closest('.task-item').remove();
                        });

                        $('#editChantierBtn').attr('href', '<?php echo e(url("/admin/edit-chantier")); ?>/' + chantier.id);
                        $('#chantierModal').modal('show');
                    },
                    error: function() {
                        toastr.error('Erreur lors du chargement des détails du chantier');
                    }
                });
            },








            
        });
        calendar.render();
        
        return calendar;
    }

    $(document).ready(function() {
        calendar = initializeCalendar();
    });


</script>




<script>

    // Handle saving new chantier with tasks
    $('#saveNewChantier').click(function() {
        // Collect chantier data
        const chantierData = {
            nom: $('#nom').val(),
            adresse: $('#adresse').val(),
            date_de_debut: $('#date_de_debut').val(),
            date_de_fin: $('#date_de_fin').val(),
            taches: []
        };
        
        // Collect tasks data
        $('.tache-item').each(function() {
            const tacheItem = $(this);
            const tache = {
                nom: tacheItem.find('.tache-nom').val(),
                description: tacheItem.find('.tache-description').val(),
                date_debut: tacheItem.find('.tache-date-debut').val(),
                date_fin: tacheItem.find('.tache-date-fin').val(),
                status: tacheItem.find('select[name="status"]').val(),
                employees: tacheItem.find('.tache-employees').val()
            };
            chantierData.taches.push(tache);
        });
        
        // Log the data to be submitted
        console.log('New Chantier Data to be submitted:', chantierData);
        
        // Submit data to controller
        $.ajax({
            url: '<?php echo e(route("admin.store-timeline-chantier")); ?>',
            method: 'POST',
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                chantier: chantierData
            },
            success: function(response) {
                console.log('Chantier created successfully:', response);
                // toastr.success('Chantier créé avec succès!');
                Toastify({
                            text: 'Chantier créé avec succès!',
                            duration: 3000,
                            close: true,
                            gravity: "top",
                            position: 'right',
                            backgroundColor: "#4CAF50"
                        }).showToast();

                $('#newChantierModal').modal('hide');
                
                // // Refresh calendar or add the new chantier to the calendar
                // if (response.chantier && response.events) {
                //     // Add the new resource (chantier)
                //     calendar.addResource({
                //         id: response.chantier.id,
                //         title: response.chantier.nom
                //     });
                    
                //     // Add the events for the new chantier
                //     response.events.forEach(function(event) {
                //         calendar.addEvent(event);
                //     });
                // } else {
                    // Just refresh the page
                    location.reload();
                // }
            },
            error: function(xhr) {
                console.error('Error creating chantier:', xhr);
                const errors = xhr.responseJSON?.errors || { error: ['Une erreur est survenue lors de la création du chantier'] };
                for (const key in errors) {
                    errors[key].forEach(error => 
                        Toastify({
                            text: error,
                            duration: 3000,
                            close: true,
                            gravity: "top",
                            position: 'right',
                            backgroundColor: "#FF4D4D"
                        }).showToast()
                    );
                }
            }
        });
    });

    // Handle editing and updating chantier with tasks
    $('.btn-success').click(function() {
        // Get chantier ID
        const chantierId = $('#chantierModal').data('chantier-id');
        if (!chantierId) {
            // toastr.error('ID du chantier manquant');
            Toastify({
                text: 'ID du chantier manquant!',
                duration: 3000,
                close: true,
                gravity: "top",
                position: 'right',
                backgroundColor: "#FF4D4D"
            }).showToast();
            return;
        }
        
        // Collect updated chantier data
        const chantierData = {
            id: chantierId,
            nom: $('#chantier_nom').val(),
            adresse: $('#chantier_adresse').val(),
            date_de_debut: $('#chantier_date_debut').val(),
            date_de_fin: $('#chantier_date_fin').val(),
            taches: []
        };
        
        // Collect tasks data
        $('.task-item').each(function() {
            const taskItem = $(this);
            const taskId = taskItem.data('task-id') || null; // Use existing ID if available
            
            const task = {
                id: taskId,
                nom: taskItem.find('.task-name').val(),
                description: taskItem.find('.task-description').val(),
                date_debut: taskItem.find('.task-date-debut').val(),
                date_fin: taskItem.find('.task-date-fin').val(),
                status: taskItem.find('.task-status').val(),
                employees: taskItem.find('.tache-employees').val()
            };
            
            chantierData.taches.push(task);
        });
        
        // Log the data to be submitted
        console.log('Updated Chantier Data to be submitted:', chantierData);
        
        // Submit data to controller
        $.ajax({
            url: '<?php echo e(route("admin.update-timeline-chantier")); ?>',
            method: 'POST',
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                chantier: chantierData
            },
            success: function(response) {
                console.log('Chantier updated successfully:', response);
                // toastr.success('Chantier mis à jour avec succès!');
                Toastify({
                            text: 'Chantier mis à jour avec succès!',
                            duration: 3000,
                            close: true,
                            gravity: "top",
                            position: 'right',
                            backgroundColor: "#4CAF50"
                        }).showToast();
                $('#chantierModal').modal('hide');
                
                // Refresh calendar or update the chantier events
                if (response.events) {
                    // Remove existing events for this chantier
                    const existingEvents = calendar.getEvents();
                    existingEvents.forEach(function(event) {
                        if (event.id == chantierId) {
                            event.remove();
                        }
                    });
                    
                    // Add the updated events
                    response.events.forEach(function(event) {
                        calendar.addEvent(event);
                    });
                } else {
                    // Just refresh the page
                    location.reload();
                }
                location.reload();
            },
            error: function(xhr) {
                console.error('Error updating chantier:', xhr);
                const errors = xhr.responseJSON?.errors || { error: ['Une erreur est survenue lors de la mise à jour du chantier'] };
                for (const key in errors) {
                    errors[key].forEach(error => 
                        Toastify({
                            text: error,
                            duration: 3000,
                            close: true,
                            gravity: "top",
                            position: 'right',
                            backgroundColor: "#FF4D4D"
                        }).showToast()
                    );
                }
            }
        });
    });

    // Initialize Delete Chantier button
    $('#deleteChantierBtn').click(function() {
        const chantierId = $('#chantierModal').data('chantier-id');
        if (!chantierId) {
            // toastr.error('ID du chantier manquant');
            Toastify({
                            text: 'ID du chantier manquant!',
                            duration: 3000,
                            close: true,
                            gravity: "top",
                            position: 'right',
                            backgroundColor: "#FF4D4D"
                        }).showToast();
            return;
        }
        
        if (confirm('Êtes-vous sûr de vouloir supprimer ce chantier et toutes ses tâches associées?')) {
            $.ajax({
                url: '<?php echo e(route("admin.delete-timeline-chantier")); ?>',
                method: 'POST',
                data: {
                    _token: '<?php echo e(csrf_token()); ?>',
                    chantier_id: chantierId
                },
                success: function(response) {
                    console.log('Chantier deleted successfully:', response);
                    // toastr.success('Chantier supprimé avec succès!');
                    Toastify({
                            text: 'Chantier supprimé avec succès!',
                            duration: 3000,
                            close: true,
                            gravity: "top",
                            position: 'right',
                            backgroundColor: "#4CAF50"
                        }).showToast();
                    $('#chantierModal').modal('hide');
                    
                    // Remove the chantier from the calendar
                    const resource = calendar.getResourceById(chantierId);
                    if (resource) {
                        resource.remove();
                    }
                    
                    // Remove events for this chantier
                    const existingEvents = calendar.getEvents();
                    existingEvents.forEach(function(event) {
                        if (event.id == chantierId) {
                            event.remove();
                        }
                    });

                    location.reload();
                },
                error: function(xhr) {
                    console.error('Error deleting chantier:', xhr);
                    // toastr.error('Une erreur est survenue lors de la suppression du chantier');
                    Toastify({
                            text: 'Une erreur est survenue lors de la suppression du chantier',
                            duration: 3000,
                            close: true,
                            gravity: "top",
                            position: 'right',
                            backgroundColor: "#FF4D4D"
                        }).showToast();
                }
            });
        }
    });

    // Fix for eventClick to properly store chantier ID
    $(document).on('click', '.fc-event-container', function() {
        // Get the chantier ID from the event and store it in the modal
        const chantierId = $(this).closest('.fc-event').data('event-id');
        if (chantierId) {
            $('#chantierModal').data('chantier-id', chantierId);
        }
    });

    // Enhance eventClick function to properly store chantier ID
    function enhanceEventClickHandler() {
        const originalEventClick = calendar.getOption('eventClick');
        
        calendar.setOption('eventClick', function(info) {
            // Store the chantier ID in the modal before showing it
            $('#chantierModal').data('chantier-id', info.event.id);
            
            // Call the original handler
            if (originalEventClick) {
                originalEventClick(info);
            }
        });
    }

    // Call enhance function after calendar initialization
    $(document).ready(function() {
        // Additional initialization
        enhanceEventClickHandler();
        
        // Reset form when opening new chantier modal
        $('#openNewChantierModal').click(function() {
            $('#newChantierForm')[0].reset();
            // Remove all task items except the first one
            $('.tache-item:not(:first)').remove();
            // Reset the first task item form
            $('.tache-item:first .tache-nom').val('');
            $('.tache-item:first .tache-description').val('');
            $('.tache-item:first .tache-date-debut').val(new Date().toISOString().split('T')[0]);
            $('.tache-item:first .tache-date-fin').val(new Date().toISOString().split('T')[0]);
            $('.tache-item:first .tache-employees').val(null).trigger('change');
        });
    });

</script>


<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/krgysgq/renovimmo/resources/views/admin/timeline-chantier.blade.php ENDPATH**/ ?>