<?php $__env->startSection('title'); ?> Planning Salariés <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <div class="btn-group">
        <a href="<?php echo e(route('admin.planning')); ?>" class="btn btn-outline-primary"><i class="fa-regular fa-calendar"></i> Vue Chantiers</a>
        <a href="<?php echo e(route('admin.planning-salarie')); ?>" class="btn btn-primary"><i class="fa-solid fa-user"></i> Vue Salariés</a>
        <a href="<?php echo e(route('admin.timeline-chantier')); ?>" class="btn btn-outline-primary"><i class="fa-solid fa-timeline"></i> Chronologie des Chantiers</a>
    </div>
    <div class="d-flex align-items-center">
        <div class="form-group mb-0 mr-3">
            <select id="employee-filter" class="form-control" style="min-width: 200px;">
                <option value="">Tous les employés</option>
                <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($employee->id); ?>" <?php echo e($selectedEmployee == $employee->id ? 'selected' : ''); ?>>
                        <?php echo e($employee->name ?? ''); ?> <?php echo e($employee->prenom ?? ''); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
        <button id="printBtn" class="btn btn-secondary text-white" style="background-color: #01152b;">
            <i class="fas fa-print"></i> Imprimer
        </button>
    </div>
</div>

<div class="row">
    <div class="col-md-12 grid-margin stretch-card">
        <div class="card">
            <div class="card-body">
                <div id="calendar"></div>
            </div>
        </div>
    </div>
</div>

<!-- Modal Détails Salarié -->
<div class="modal fade" id="employeeModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Détails du Salarié</h5>
                <button type="button" class="close" data-bs-dismiss="modal">
                    <span>&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row mb-4">
                    <div class="col-md-6">
                        <h4 id="employeeName"></h4>
                    </div>
                    <div class="col-md-6 text-right">
                        <h5>Jours travaillés ce mois: <span id="totalDays" class="badge badge-primary"></span></h5>
                    </div>
                </div>
                <div id="tasksList">
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fermer</button>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<link href='https://cdn.jsdelivr.net/npm/fullcalendar@5.11.3/main.min.css' rel='stylesheet' />
<script src='https://cdn.jsdelivr.net/npm/fullcalendar@5.11.3/main.min.js'></script>
<script src='https://cdn.jsdelivr.net/npm/fullcalendar@5.11.3/locales/fr.js'></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>

<script>
var calendar;

function initializeCalendar() {
    var calendarEl = document.getElementById('calendar');
    calendar = new FullCalendar.Calendar(calendarEl, {
        themeSystem: 'bootstrap',
        locale: 'fr',
        initialView: 'dayGridMonth',
        headerToolbar: {
            left: 'prev,next today',
            center: 'title',
            right: 'dayGridMonth,timeGridWeek,dayGridDay,listMonth'
        },
        weekNumbers: false,
        nowIndicator: true,
        // dayMaxEvents: true,
        navLinks: true,
        expandRows:true,
        // selectable: true,
        allDaySlot:true,
        
        events: <?php echo json_encode($events, 15, 512) ?>,
        
        hiddenDays: [0, 6], // Hide Sunday (0) and Saturday (6)
        eventDisplay: 'block',
        displayEventEnd: true,
        eventDidMount: function(info) {
            // Add tooltip with additional information
            $(info.el).tooltip({
                title: `${info.event.extendedProps.employee_name}\nTâche: ${info.event.extendedProps.tache_nom}\nChantier: ${info.event.extendedProps.chantier_nom}\nJours: ${info.event.extendedProps.nb_jours}`,
                placement: 'top',
                trigger: 'hover',
                container: 'body'
            });
        },
        eventClick: function(info) {
            var eventId = info.event.extendedProps.employee_id + '-' + 
                         info.event.start.getFullYear() + '-' + 
                         String(info.event.start.getMonth() + 1).padStart(2, '0');
                         
            $.ajax({
                url: '/admin/get-salarie-details/' + eventId,
                method: 'GET',
                success: function(data) {
                    var totalDays = 0;
                    var tasksHtml = '';
                    
                    if (data.taches && data.taches.length > 0) {
                        data.taches.forEach(function(tache) {
                            tasksHtml += `
                                <div class="task-item mb-3">
                                    <h6 class="font-weight-bold">${tache.chantier.nom} - ${tache.nom}</h6>
                                    <div class="task-details">
                                        <div><strong>Date début:</strong> ${tache.date_debut}</div>
                                        <div><strong>Date fin:</strong> ${tache.date_fin}</div>
                                        <div><strong>Jours travaillés:</strong> ${tache.nb_jours}</div>
                                    </div>
                                </div>
                            `;
                            totalDays += parseInt(tache.nb_jours || 0);
                        });
                    } else {
                        tasksHtml = '<p>Aucune tâche pour ce mois</p>';
                    }

                    $('#employeeName').text(data.name);
                    $('#tasksList').html(tasksHtml);
                    $('#totalDays').text(totalDays);
                    $('#employeeModal').modal('show');
                },
                error: function() {
                    toastr.error('Erreur lors du chargement des détails du salarié');
                }
            });
        }
    });
    calendar.render();
    return calendar;
}

$(document).ready(function() {
    calendar = initializeCalendar();

    // Handle employee filter change
    document.getElementById('employee-filter').addEventListener('change', function() {
        var selectedEmployee = this.value;
        var url = new URL(window.location.href);
        
        if (selectedEmployee) {
            url.searchParams.set('employee_id', selectedEmployee);
        } else {
            url.searchParams.delete('employee_id');
        }
        
        window.location.href = url.toString();
    });

    // Print functionality
    $('#printBtn').click(function() {
        var printWindow = window.open('', '_blank');
        var calendarEl = document.querySelector('.fc');
        
        if (!calendarEl) {
            alert('Erreur: Calendrier non trouvé');
            return;
        }

        var printContent = `
            <!DOCTYPE html>
            <html>
            <head>
                <title>Planning des Salariés</title>
                <link href="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.3/main.min.css" rel="stylesheet" />
                <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
                <style>
                    @media  print {
                        @page  {
                            size: landscape;
                            margin: 1cm;
                        }
                        body {
                            margin: 0;
                            padding: 15px;
                        }
                        .fc-header-toolbar {
                            display: none !important;
                        }
                        .print-header {
                            margin-bottom: 20px;
                        }
                        .fc-view {
                            background-color: white !important;
                        }
                        .fc td, .fc th {
                            border: 1px solid #ddd !important;
                        }
                    }
                    .print-header {
                        text-align: center;
                        padding: 20px;
                    }
                    .fc-event {
                        page-break-inside: avoid !important;
                    }
                    .fc-event-title {
                        white-space: normal !important;
                    }
                </style>
            </head>
            <body>
                <div class="print-header">
                    <h2>Planning des Salariés</h2>
                    <p>Date d'impression: ${new Date().toLocaleDateString('fr-FR')}</p>
                </div>
                ${calendarEl.outerHTML}
                <script src="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.3/main.min.js"><\/script>
                <script>
                    window.onload = function() {
                        setTimeout(function() {
                            window.print();
                            window.close();
                        }, 500);
                    }
                <\/script>
            </body>
            </html>
        `;
        
        printWindow.document.write(printContent);
        printWindow.document.close();
    });
});
</script>

<style>
.task-item {
    border-bottom: 1px solid #eee;
    padding-bottom: 10px;
}

.task-item:last-child {
    border-bottom: none;
}

.task-details {
    font-size: 0.9em;
    margin-top: 5px;
    color: #666;
}

.fc-event {
    cursor: pointer;
}

.fc-event-title {
    font-weight: bold;
    white-space: normal !important;
    overflow: hidden;
}

@media  print {
    .btn-group, .form-group, #printBtn {
        display: none !important;
    }
    .card {
        border: none !important;
    }
    .card-body {
        padding: 0 !important;
    }
}

.absence-event {
    opacity: 0.8;
}
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/krgysgq/renovimmo/resources/views/admin/planning-salarie.blade.php ENDPATH**/ ?>