<?php $__env->startSection('title'); ?> Gestion de Stock - <?php echo e($element->element); ?> <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="page-title">
    <div class="row mb-3">
        <div class="col-12 col-md-6 order-md-1 order-last">
            <h2 class="mr-auto text-lg font-medium">Gestion de Stock - <?php echo e($element->element); ?></h2>
        </div>
        <div class="col-12 col-md-6 order-md-2 order-first">
            <nav aria-label="breadcrumb" class="breadcrumb-header float-start float-lg-end">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="/">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="/admin/elements">Elements</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Gestion de Stock</li>
                </ol>
            </nav>
        </div>
    </div>
</div>

<!-- Stock Info Card -->
<div class="row">
    <div class="col-md-12 mb-4">
        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <h5>Stock Actuel</h5>
                        <h2 class="font-weight-bold"><?php echo e($element->quantity); ?></h2>
                    </div>
                    <div class="col-md-4">
                        <h5>Seuil d'Alerte</h5>
                        <h2 class="font-weight-bold"><?php echo e($element->stock_alert); ?></h2>
                    </div>
                    <div class="col-md-4">
                        <h5>Statut</h5>
                        <?php if($element->quantity < $element->stock_alert): ?>
                            <span class="badge bg-danger">Stock Bas</span>
                        <?php else: ?>
                            <span class="badge bg-success">Stock Normal</span>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Stock Movement Forms -->
<div class="row">
    <!-- Add Stock Form -->
    <div class="col-md-6 mb-4">
        <div class="card">
            <div class="card-header">
                <h4>Ajouter du Stock</h4>
            </div>
            <div class="card-body">
                <form method="POST" action="<?php echo e(route('admin.add-stock')); ?>">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="element_id" value="<?php echo e($element->id); ?>">
                    
                    <div class="form-group">
                        <label for="quantity">Quantité</label>
                        <input type="number" class="form-control" id="quantity" name="quantity" min="1" required>
                    </div>

                    <div class="form-group">
                        <label for="reference">Référence (Optionnel)</label>
                        <input type="text" class="form-control" id="reference" name="reference" placeholder="Numéro de commande, etc.">
                    </div>

                    <div class="form-group">
                        <label for="notes">Notes (Optionnel)</label>
                        <textarea class="form-control" id="notes" name="notes" rows="2"></textarea>
                    </div>

                    <button type="submit" class="btn btn-primary">Ajouter au Stock</button>
                </form>
            </div>
        </div>
    </div>

    <!-- Remove Stock Form -->
    <div class="col-md-6 mb-4">
        <div class="card">
            <div class="card-header">
                <h4>Retirer du Stock</h4>
            </div>
            <div class="card-body">
                <form method="POST" action="<?php echo e(route('admin.remove-stock')); ?>">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="element_id" value="<?php echo e($element->id); ?>">
                    
                    <div class="form-group">
                        <label for="quantity">Quantité</label>
                        <input type="number" class="form-control" id="quantity" name="quantity" min="1" max="<?php echo e($element->quantity); ?>" required>
                    </div>

                    <div class="form-group">
                        <label for="reference">Référence (Optionnel)</label>
                        <input type="text" class="form-control" id="reference" name="reference" placeholder="Projet, utilisation, etc.">
                    </div>

                    <div class="form-group">
                        <label for="notes">Notes (Optionnel)</label>
                        <textarea class="form-control" id="notes" name="notes" rows="2"></textarea>
                    </div>

                    <button type="submit" class="btn btn-danger">Retirer du Stock</button>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Stock Movement History -->
<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h4>Historique des Mouvements</h4>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Type</th>
                                <th>Quantité</th>
                                <th>Référence</th>
                                <th>Notes</th>
                                <th>Utilisateur</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $movements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $movement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($movement->created_at->format('d/m/Y H:i')); ?></td>
                                <td>
                                    <?php if($movement->type == 'in'): ?>
                                        <span class="badge bg-success">Entrée</span>
                                    <?php else: ?>
                                        <span class="badge bg-danger">Sortie</span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e($movement->quantity); ?></td>
                                <td><?php echo e($movement->reference ?? '-'); ?></td>
                                <td><?php echo e($movement->notes ?? '-'); ?></td>
                                <td><?php echo e($movement->user->name); ?></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u400861240/domains/zydevgroup.com/public_html/renovimmo/resources/views/admin/stock-movement.blade.php ENDPATH**/ ?>