
<?php $__env->startSection('title'); ?> Modifier Absence <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-lg-12 grid-margin stretch-card">
        <div class="card">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h4 class="card-title">Modifier Absence</h4>
                    <a href="<?php echo e(route('admin.absences')); ?>" class="btn btn-secondary">
                        <i class="fas fa-arrow-left"></i> Retour
                    </a>
                </div>

                <form class="forms-sample" method="POST" action="<?php echo e(route('admin.update-absence')); ?>">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="absence_id" value="<?php echo e($absence->id); ?>">
                    <input type="hidden" name="employee_id" value="<?php echo e($absence->employee_id); ?>">
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="employee_id">Salarié</label>
                                <h4 class="font-weight-bold"><?php echo e($absence->employee->prenom); ?> <?php echo e($absence->employee->name); ?></h4>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                            <label for="category">Catégorie</label>
                            <select class="form-control" name="category" id="category" required>
                                <option value="" disabled>Sélectionner une catégorie</option>
                                <option value="Arrêt maladie" <?php echo e(trim($absence->category) == 'Arrêt maladie' ? 'selected' : ''); ?>>Arrêt maladie</option>
                                <option value="Absence injustifié" <?php echo e(trim($absence->category) == 'Absence injustifié' ? 'selected' : ''); ?>>Absence injustifié</option>
                                <option value="Congé sans solde" <?php echo e(trim($absence->category) == 'Congé sans solde' ? 'selected' : ''); ?>>Congé sans solde</option>
                                <option value="Autre" <?php echo e(trim($absence->category) == 'Autre' ? 'selected' : ''); ?>>Autre</option>
                            </select>
                        </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="date">Date de debut</label>
                                <input type="date" class="form-control" name="date_debut" value="<?php echo e($absence->date_debut->format('Y-m-d')); ?>" required>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="date">Date de fin</label>
                                <input type="date" class="form-control" name="date_fin" value="<?php echo e($absence->date_fin->format('Y-m-d')); ?>" required>
                            </div>
                        </div>

                    </div>

                    <div class="mt-4">
                        <button type="submit" class="btn btn-primary mr-2">
                            <i class="fas fa-save"></i> Enregistrer
                        </button>
                        <a href="<?php echo e(route('admin.absences')); ?>" class="btn btn-light">
                            <i class="fas fa-times"></i> Annuler
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php if(session('success')): ?>
<div class="alert alert-success alert-dismissible fade show" role="alert">
    <?php echo e(session('success')); ?>

    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
        <span aria-hidden="true">&times;</span>
    </button>
</div>
<?php endif; ?>

<?php if($errors->any()): ?>
<div class="alert alert-danger alert-dismissible fade show" role="alert">
    <ul class="mb-0">
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li><?php echo e($error); ?></li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </ul>
    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
        <span aria-hidden="true">&times;</span>
    </button>
</div>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script>
$(document).ready(function() {
    // Initialize select2 if you're using it
    if ($.fn.select2) {
        $('select[name="employee_id"]').select2({
            placeholder: "Sélectionner un salarié",
            width: '100%'
        });
    }
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u400861240/domains/zydevgroup.com/public_html/renovimmo/resources/views/admin/edit-absence.blade.php ENDPATH**/ ?>