
<?php $__env->startSection('title'); ?> Absences <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-lg-12 grid-margin stretch-card">
        <div class="card">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h4 class="card-title">Liste des Absences</h4>
                    <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#addAbsenceModal">
                        <i class="fa fa-plus"></i> Ajouter une Absence
                    </button>
                </div>
                <div class="table-responsive">
                    <table class="table table-striped table-borderless datatables" id="table1">
                        <thead>
                            <tr>
                                <th>Salarié</th>
                                <th>Catégorie</th>
                                <!--
                                <th>Chantier</th>
                                <th>Tâche</th>
                                -->
                                <th>Date de début</th>
                                <th>Date de fin</th>
                                <th>Jours absents</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $absences; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $absence): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($absence->employee->prenom); ?> <?php echo e($absence->employee->name); ?></td>
                                <td><?php echo e($absence->category); ?></td>
                                <!--
                                <td><?php echo e($absence->chantier ? $absence->chantier->nom : 'N/A'); ?></td>
                                <td><?php echo e($absence->tache ? $absence->tache->nom : 'N/A'); ?></td>
                                -->
                                <td><?php echo e($absence->date_debut->format('d/m/Y')); ?></td>
                                <td><?php echo e($absence->date_fin ? $absence->date_fin->format('d/m/Y') : 'En cours'); ?></td>
                                <td><?php echo e($absence->jours_absence); ?></td>

                                <td>
                                    <a href='<?php echo e(route("admin.edit-absence", $absence->id)); ?>' class="btn btn-sm btn-info"><i class="fas fa-edit"></i></a>
                                    <button class="btn btn-sm btn-danger delete" data-id="<?php echo e($absence->id); ?>" href="javascript::void();">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add Absence Modal -->
<div class="modal fade" id="addAbsenceModal" tabindex="-1" role="dialog" aria-labelledby="addAbsenceModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addAbsenceModalLabel">Ajouter une Absence</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form method="post" action="<?php echo e(route('admin.insert-absence')); ?>" id="addAbsenceForm">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="employee_id">Salarié</label>
                        <select class="form-control" name="employee_id" required>
                            <option value="">Sélectionner un salarié</option>
                            <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($employee->id); ?>"><?php echo e($employee->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="category">Catégorie</label>
                        <select class="form-control" name="category" required>
                            <option value="">Sélectionner une catégorie</option>
                            <option value="Arrêt maladie">Arrêt maladie</option>
                            <option value="Absence injustifié">Absence injustifié</option>
                            <option value="Congé sans solde">Congé sans solde</option>
                            <option value="Autre">Autre</option>
                        </select>
                    </div>

                    <!--
                    <div class="form-group">
                        <label for="chantier_id">Chantier (optionnel)</label>
                        <select class="form-control" name="chantier_id">
                            <option value="">Sélectionner un chantier</option>
                            <?php $__currentLoopData = $chantiers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chantier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($chantier->id); ?>"><?php echo e($chantier->nom); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="tache_id">Tâche (optionnel)</label>
                        <select class="form-control" name="tache_id" disabled>
                            <option value="">Sélectionner une tâche</option>
                        </select>
                    </div>
                    -->

                    <div class="form-group">
                        <label for="date_debut">Date de début</label>
                        <input type="date" class="form-control" name="date_debut" required>
                    </div>

                    <div class="form-group">
                        <label for="date_fin">Date de fin</label>
                        <input type="date" class="form-control" name="date_fin">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Fermer</button>
                    <button type="submit" class="btn btn-primary">Enregistrer</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script>
$(document).ready(function() {
    // Handle chantier selection to load tasks
    $('select[name="chantier_id"]').change(function() {
        var chantier_id = $(this).val();
        var tache_select = $('select[name="tache_id"]');
        
        if (chantier_id) {
            $.get('/admin/get-chantier-taches/' + chantier_id, function(data) {
                tache_select.empty();
                tache_select.append('<option value="">Sélectionner une tâche</option>');
                
                data.forEach(function(tache) {
                    tache_select.append(`<option value="${tache.id}">${tache.nom}</option>`);
                });
                
                tache_select.prop('disabled', false);
            });
        } else {
            tache_select.empty();
            tache_select.append('<option value="">Sélectionner une tâche</option>');
            tache_select.prop('disabled', true);
        }
    });

    $('.delete').click(function(){
	    
		var dataId = $(this).attr("data-id");
		Swal.fire({
		  title: "Are you sure?",
		  text: "Once you confirm, this action cannot be undone!",
		  icon: "warning",
		  showCancelButton: true,
		  confirmButtonColor: "#3085d6",
		  cancelButtonColor: "#d33",
		  confirmButtonText: "Yes, delete!"
		}).then((result) => {
		  if (result.isConfirmed) {
		    window.open(`<?php echo e(route("admin.delete-absence", [":dataId"])); ?>`.replace(':dataId', dataId),"_self");
		  }
		});
	});
});
</script>




<script>
  $('#table1').DataTable({
        dom: 'Bfrtip',
        language: {
            url: '<?php echo e(asset("assets/fr-FR.json")); ?>'
        },
        buttons: [
            {
				title:'Affectation des Matériels',
                extend: 'copy',
                exportOptions: {
                    columns: [0, 1, 2, 3, 4]
                }
            },
            {
				title:'Affectation des Matériels',
                extend: 'csv',
                exportOptions: {
                    columns: [0, 1, 2, 3, 4]
                }
            },
            {
				title:'Affectation des Matériels',
                extend: 'excel',
                exportOptions: {
                    columns: [0, 1, 2, 3, 4]
                }
            },
            {
				title:'Affectation des Matériels',
                extend: 'pdf',
				text: 'PDF',
                exportOptions: {
					modifier: {
                    page: 'current'
                },
                    columns: [0, 1, 2, 3, 4]
                }
            },
            {
				title: '<h2 style="text-align: center;">Affectation des Matériels</h2>', // Title centered
				extend: 'print',
				exportOptions: {
					columns: [0, 1, 2, 3, 4]
				},
				customize: function (win) {
					$(win.document.body)
						.css('font-size', '10pt') // Optional: Adjust font size
						.prepend(
							'<div style="text-align: center;"><img src="<?php echo e(asset('assets/images/RenovImmo-long.png')); ?>" style="width: 80%; margin-bottom: 20px;" /></div>'
						);

					// Style the title
					$(win.document.body).find('h1')
						.css('text-align', 'center') // Ensure the title is centered
						.css('margin-bottom', '20px'); // Optional: Add spacing below the title
						
						
					// Style the table explicitly
					$(win.document.body).find('table').addClass('table table-bordered table-striped');
				}
			},

            'colvis'
        ]
    });
</script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u400861240/domains/zydevgroup.com/public_html/renovimmo/resources/views/admin/absences.blade.php ENDPATH**/ ?>