
<?php $__env->startSection('title'); ?> Gestion des Elements <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>




<div class="page-title">
    <div class="row mb-3">
        <div class="col-12 col-md-6 order-md-1 order-last">
        <h2 class="mr-auto text-lg font-medium">Famille : <?php echo e($famille->nom); ?></h2>
        </div>
        <div class="col-12 col-md-6 order-md-2 order-first">
            <nav aria-label="breadcrumb" class="breadcrumb-header float-start float-lg-end">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="/">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="/admin/familles">Familles</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Elements 
                    </li>
                </ol>
            </nav>
        </div>
    </div>
</div>

<br>


<div class="row">
    <div class="col-md-12 grid-margin stretch-card">
        <div class="card">
        <div class="card-body">
            <div class="table-responsive">
            <table class="table table-striped table-borderless  datatables" id="table1" >
                <thead>
                <tr>
                    <th></th>
                    <th>Image</th>
                    <th>Element</th>
                    <th>Quantité</th>
                </tr>  
                </thead>
                <tbody>
                <?php $i=1; 
                if(!empty($famille->elements))
						
						$elements = json_decode($famille->elements);
						foreach($elements as $elt){
							$element = \App\Models\Element::find($elt);
							if($element)?>

                    <tr>
	                <td><?php echo e($i++); ?></td>
                    <td>
                        <?php if($element->photo): ?>
							<?php $photos = json_decode($element->photo); ?>
							<?php if(!empty($photos) && isset($photos[0]) && file_exists(public_path('uploads/' . $photos[0]))): ?>
								<img src="<?php echo e(asset('uploads/' . $photos[0])); ?>" alt="Photo" class="img-fluid rounded" height="200" width="auto"/>
							<?php else: ?>
								<img src="<?php echo e(asset('assets/images/no_image.png')); ?>" alt="No Image" class="img-fluid rounded" height="200" width="auto"/>
							<?php endif; ?>
						<?php else: ?>
							<img src="<?php echo e(asset('assets/images/no_image.png')); ?>" alt="No Images" class="img-fluid rounded" height="200" width="auto"/>
						<?php endif; ?>
                    </td>
	                <td class="font-weight-bold"><?php echo e($element->element); ?></td>
	                <td class="font-weight-bold"><?php echo e($element->quantity); ?></td>

	                <td>
						
	                </td>
	              </tr>
                
                  <?php	}?>
						
                
                </tbody>
            </table>
            </div>
        </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('script'); ?>



<script>
	// Simple Datatable
	let table1 = document.querySelector('#table1');
	let dataTable = new simpleDatatables.DataTable(table1);
</script>

<script>
	$('.delete').click(function(){
		var dataId = $(this).attr("data-id");
		Swal.fire({
		  title: "Êtes-vous sûr?",
		  text: "Une fois que vous confirmez, cette action ne peut plus être annulée!",
		  icon: "warning",
		  showCancelButton: true,
		  confirmButtonColor: "#3085d6",
		  cancelButtonColor: "#d33",
		  confirmButtonText: "Oui, supprime-le!"
		}).then((result) => {
		  if (result.isConfirmed) {
		    Swal.fire({
		      title: "Supprimé!",
		      text: "La suppression est réussie.",
		      icon: "success"
		    });
		    window.open("<?php echo e(route('admin.delete-element', ['id' => 'dataId'])); ?>".replace('dataId', dataId),"_self");
		  }
		});
	});
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u400861240/domains/zydevgroup.com/public_html/renovimmo/resources/views/admin/famille-details.blade.php ENDPATH**/ ?>