
<!DOCTYPE html>
<html lang="en">
<head>

<meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="author" content="ZYDEV">
  
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title>Renov'Immo | Solution de Gestion</title>
  <!-- plugins:css -->
  <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/feather/feather.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/ti-icons/css/themify-icons.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/css/vendor.bundle.base.css')); ?>">
  <!-- endinject -->
  <!-- Plugin css for this page -->
  <!-- End plugin css for this page -->
  <!-- inject:css -->
  <link rel="stylesheet" href="<?php echo e(asset('assets/css/vertical-layout-light/style.css')); ?>">
  <!-- endinject -->
  <link rel="shortcut icon" href="<?php echo e(asset('assets/images/favicon.ico')); ?>" />
  <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/toastify/toastify.css')); ?>">
  <link href="https://unpkg.com/@tabler/icons-webfont@latest/tabler-icons.min.css" rel="stylesheet">
    <!-- <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/toastr/toatr.css')); ?>"> -->
    
</head>
<body>
    <?php if(session()->has('error')): ?> 
      <script type="text/javascript">
        document.addEventListener('DOMContentLoaded', function () {
            Toastify({
                text: "<?php echo e(Session::get('error')); ?>",
                duration: 3000,
                close: true,
                gravity: "top",
                position: "right",
                backgroundColor: "#F44336", // Background color for error
                stopOnFocus: true
            }).showToast();
        });
      </script>
    <?php endif; ?>
    <?php if(session()->has('success')): ?>
      <script type="text/javascript">
        document.addEventListener('DOMContentLoaded', function () {
            Toastify({
                text: "<?php echo e(Session::get('success')); ?>",
                duration: 3000, // Duration in milliseconds
                close: true, // Show the close icon
                gravity: "top", // Position vertically: top or bottom
                position: "right", // Position horizontally: left, center, or right
                backgroundColor: "#4CAF50", // Background color for success
                stopOnFocus: true // Prevents dismissing of toast on hover
            }).showToast();
        });
      </script>
    <?php endif; ?>
    <?php if($errors->any()): ?>
      <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <script type="text/javascript">
          document.addEventListener('DOMContentLoaded', function () {
              Toastify({
                  text: "<?php echo e($error); ?>",
                  duration: 3000,
                  close: true,
                  gravity: "top",
                  position: "right",
                  backgroundColor: "#F44336", // Background color for error
                  stopOnFocus: true
              }).showToast();
          });
        </script>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>

<div class="container-scroller">
    <div class="container-fluid page-body-wrapper full-page-wrapper">
        <div class="content-wrapper d-flex align-items-center auth px-0" style=" background-color: #02111e;">
            <div class="row w-100 mx-0">
                <div class="col-lg-4 mx-auto">
                    <div class="auth-form-light text-center py-5 px-4 px-sm-5">
                        <h3>Espace Reservé aux administrateurs</h3>
                        <div class="brand-logo">
                            <img src="<?php echo e(asset('assets/images/RenovImmo-FOND-BLANC.jpg')); ?>" alt="logo">
                        </div>
                        <h6 class="font-weight-light">Se connecter à la Plateforme Renov'Immo.</h6>
                        <form class="pt-3" method="post" action="<?php echo e(route('admin.check-login')); ?>">
                        <?php echo csrf_field(); ?>
                            <div class="form-group">
                                <input type="email" name="email" value class="form-control form-control-lg" placeholder="Adresse Email" required>
                            </div>
                            <div class="form-group">

                                <input type="password" name="password" class="pass-input form-control form-control-lg" placeholder="Mot de Passe" required>
                            </div>
                            <div class="mt-3">
                                <button type="submit" class="btn btn-block btn-primary btn-lg font-weight-medium auth-form-btn">Se Connecter</button>
                            </div>
                                        
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- content-wrapper ends -->
    </div>
    <!-- page-body-wrapper ends -->
</div>





    <script src="<?php echo e(asset('assets/js/off-canvas.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/hoverable-collapse.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/template.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/settings.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/todolist.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/toastify/toastify.js')); ?>"></script>
</body>
</html><?php /**PATH /home/krgysgq/renovimmo/resources/views/admin/login.blade.php ENDPATH**/ ?>