<?php $__env->startSection('title'); ?> Affectation des Matériels <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="intro-y mb-3 flex items-center">
	<div class="row">
		<div class="col-8 mb-4 mb-xl-0">
		    <h2 class="mr-auto text-lg font-medium">Affectation des Matériels</h2>
		</div>

		<div class="col-4">
			<div class="justify-content-end d-flex">
				<a href="<?php echo e(route('admin.materiels')); ?>" class="btn btn-primary mr-2">
                    <i class="fa fa-arrow-left"></i> Retour aux Matériels
                </a>
			</div>			 
		</div>
	</div>
</div>

<br>

<div class="row">
    <div class="col-md-12 grid-margin stretch-card">
        <div class="card">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped table-borderless datatables" id="table1">
                        <thead>
                            <tr>
                                <th></th>
                                <th>Photo</th>
                                <th>Matériel</th>
                                <th>Référence</th>
                                <th>Salarié</th>
                                <th>Date d'affectation</th>
                                <th>Date de remise</th>
                                <th>Date de retour</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>  
                        </thead>
                        <tbody>
                            <?php $i=1; ?>
                            <?php $__currentLoopData = $affectations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $affectation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php 
                                $materiel = \App\Models\Materiel::find($affectation->materiel_id);
                                $salarie = \App\Models\User::find($affectation->salarie_id);
                            ?>
                            <tr>
                                <td><?php echo e($i++); ?></td>
                                <td>
                                    <?php if($materiel->photo): ?>
                                        <?php $photos = json_decode($materiel->photo); ?>
                                        <?php if(!empty($photos)): ?>
                                            <?php $__currentLoopData = $photos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if(file_exists(public_path('uploads/' . $photo))): ?>
                                                    <img src="<?php echo e(asset('uploads/' . $photo)); ?>" alt="Photo" class="rounded" height="50" width="50"/>
                                                    <?php break; ?>
                                                <?php else: ?>
                                                    <img src="<?php echo e(asset('assets/images/no_image.png')); ?>" alt="No Image" class="rounded" height="50" width="50"/>
                                                    <?php break; ?>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php else: ?>
                                            <img src="<?php echo e(asset('assets/images/no_image.png')); ?>" alt="No Image" class="rounded" height="50" width="50"/>
                                        <?php endif; ?>
                                    <?php else: ?>
                                        <img src="<?php echo e(asset('assets/images/no_image.png')); ?>" alt="No Image" class="rounded" height="50" width="50"/>
                                    <?php endif; ?>
                                </td>
                                <td class="font-weight-bold">
                                    <?php if($materiel): ?>
                                        <?php echo e($materiel->materiel); ?>

                                    <?php else: ?>
                                        <span class="text-muted">Matériel supprimé</span>
                                    <?php endif; ?>
                                </td>
                                <td class="font-weight-bold">
                                    <?php if($materiel->reference): ?>
                                        <?php echo e($materiel->reference); ?>

                                    <?php else: ?>
                                        <span class="text-muted">Aucun</span>
                                    <?php endif; ?>
                                </td>
                                <td class="font-weight-bold">
                                    <?php if($salarie): ?>
                                    <?php echo e($salarie->prenom); ?> <?php echo e($salarie->name); ?>

                                    <?php else: ?>
                                        <span class="text-muted">Salarié supprimé</span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e(\Carbon\Carbon::parse($affectation->date_de_prise)->format('d/m/Y')); ?></td>
                                <td><?php echo e(\Carbon\Carbon::parse($affectation->date_de_remise)->format('d/m/Y')); ?></td>
                                <td>
                                    <?php if($affectation->date_retour): ?>
                                        <?php echo e(\Carbon\Carbon::parse($affectation->date_retour)->format('d/m/Y')); ?>

                                    <?php else: ?>
                                        <span class="badge bg-warning text-white">En cours</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($affectation->status == 'returned'): ?>
                                        <span class="badge bg-success text-white">Retourné</span>
                                    <?php else: ?>
                                        <span class="badge bg-primary text-white">Affecté</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($affectation->status != 'returned'): ?>
                                        <a href="javascript:void(0);" class="text-success return-materiel" data-id="<?php echo e($affectation->id); ?>">
                                            <i class="fa fa-check-circle"></i> Marquer comme retourné
                                        </a>
                                    <?php endif; ?>
                                    <a data-id="<?php echo e($affectation->id); ?>" class="text-danger delete" href="javascript:void(0);">
                                        <i class="fa-solid fa-trash"></i> Supprimer
                                    </a>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script>
   

    // Delete affectation
    $('.delete').click(function(){
        var dataId = $(this).attr("data-id");
        Swal.fire({
            title: "Êtes-vous sûr?",
            text: "Une fois que vous confirmez, cette action ne peut plus être annulée!",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "Oui, supprimer!",
            cancelButtonText: "Annuler"
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = "/admin/delete-affectation/"+dataId;
            }
        });
    });

    // Return materiel
    $('.return-materiel').click(function(){
        var dataId = $(this).attr("data-id");
        Swal.fire({
            title: "Confirmer le retour",
            text: "Voulez-vous marquer ce matériel comme retourné?",
            icon: "question",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "Oui, confirmer",
            cancelButtonText: "Annuler"
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = "/admin/return-materiel/"+dataId;
            }
        });
    });
</script>



<script>
  $('#table1').DataTable({
        dom: 'Bfrtip',
        language: {
            url: '<?php echo e(asset("assets/fr-FR.json")); ?>'
        },
        buttons: [
            {
				title:'Affectation des Matériels',
                extend: 'copy',
                exportOptions: {
                    columns: [0, 2, 3, 4, 5, 6, 7, 8]
                }
            },
            {
				title:'Affectation des Matériels',
                extend: 'csv',
                exportOptions: {
                    columns: [0, 2, 3, 4, 5, 6, 7, 8]
                }
            },
            {
				title:'Affectation des Matériels',
                extend: 'excel',
                exportOptions: {
                    columns: [0, 2, 3, 4, 5, 6, 7, 8]
                }
            },
            {
				title:'Affectation des Matériels',
                extend: 'pdf',
				text: 'PDF',
                exportOptions: {
					modifier: {
                    page: 'current'
                },
                    columns: [0, 2, 3, 4, 5, 6, 7, 8]
                }
            },
            {
				title: '<h2 style="text-align: center;">Affectation des Matériels</h2>', // Title centered
				extend: 'print',
				exportOptions: {
					columns: [0, 2, 3, 4, 5, 6, 7, 8]
				},
				customize: function (win) {
					$(win.document.body)
						.css('font-size', '10pt') // Optional: Adjust font size
						.prepend(
							'<div style="text-align: center;"><img src="<?php echo e(asset('assets/images/RenovImmo-long.png')); ?>" style="width: 80%; margin-bottom: 20px;" /></div>'
						);

					// Style the title
					$(win.document.body).find('h1')
						.css('text-align', 'center') // Ensure the title is centered
						.css('margin-bottom', '20px'); // Optional: Add spacing below the title
						
						
					// Style the table explicitly
					$(win.document.body).find('table').addClass('table table-bordered table-striped');
				}
			},

            'colvis'
        ]
    });
</script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u400861240/domains/zydevgroup.com/public_html/renovimmo/resources/views/admin/affectation.blade.php ENDPATH**/ ?>